<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Report ServiceType
 * @subpackage Services
 */
class Report extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named reportItOptions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\ReportItOptionsRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\ReportItOptionsResponse|bool
     */
    public function reportItOptions(\QCC\CampusM\CloudService\StructType\ReportItOptionsRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->reportItOptions($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\ReportItOptionsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
