<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Push ServiceType
 * @subpackage Services
 */
class Push extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named pushCentreStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\PushCentreStatusRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\PushCentreStatusResponse|bool
     */
    public function pushCentreStatus(\QCC\CampusM\CloudService\StructType\PushCentreStatusRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->pushCentreStatus($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\PushCentreStatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
