<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Position ServiceType
 * @subpackage Services
 */
class Position extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named positionAction
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\PositionActionRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\PositionActionResponse|bool
     */
    public function positionAction(\QCC\CampusM\CloudService\StructType\PositionActionRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->positionAction($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\PositionActionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
