<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for OA ServiceType
 * @subpackage Services
 */
class OA extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named oAuthToken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\OAuthTokenRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\OAuthTokenResponse|bool
     */
    public function oAuthToken(\QCC\CampusM\CloudService\StructType\OAuthTokenRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->oAuthToken($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named oAuthRefresh
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\OAuthRefreshRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\OAuthRefreshResponse|bool
     */
    public function oAuthRefresh(\QCC\CampusM\CloudService\StructType\OAuthRefreshRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->oAuthRefresh($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\OAuthRefreshResponse|\QCC\CampusM\CloudService\StructType\OAuthTokenResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
