<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for MEPS ServiceType
 * @subpackage Services
 */
class MEPS extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named MEPStartup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\StartupMEPRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\StartupMEPResponse|bool
     */
    public function MEPStartup(\QCC\CampusM\CloudService\StructType\StartupMEPRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->MEPStartup($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\StartupMEPResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
