<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Insert ServiceType
 * @subpackage Services
 */
class Insert extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named insertXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\InsertXmlRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\InsertXmlResponse|bool
     */
    public function insertXml(\QCC\CampusM\CloudService\StructType\InsertXmlRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->insertXml($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named insertDirectoryList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\InsertDirectoryListRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\InsertDirectoryListResponse|bool
     */
    public function insertDirectoryList(\QCC\CampusM\CloudService\StructType\InsertDirectoryListRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->insertDirectoryList($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\InsertDirectoryListResponse|\QCC\CampusM\CloudService\StructType\InsertXmlResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
