<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Directory ServiceType
 * @subpackage Services
 */
class Directory extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named directoryList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\DirectoryListRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\DirectoryListResponse|bool
     */
    public function directoryList(\QCC\CampusM\CloudService\StructType\DirectoryListRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->directoryList($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\DirectoryListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
