<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delegate ServiceType
 * @subpackage Services
 */
class Delegate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named delegateDir
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\DelegateDirRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\DelegateDirResponse|bool
     */
    public function delegateDir(\QCC\CampusM\CloudService\StructType\DelegateDirRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->delegateDir($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named delegateDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\DelegateDetailsRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\DelegateDetailsResponse|bool
     */
    public function delegateDetails(\QCC\CampusM\CloudService\StructType\DelegateDetailsRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->delegateDetails($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\DelegateDetailsResponse|\QCC\CampusM\CloudService\StructType\DelegateDirResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
