<?php

namespace QCC\CampusM\CloudService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cleanup ServiceType
 * @subpackage Services
 */
class Cleanup extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named cleanupExpiredAlerts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \QCC\CampusM\CloudService\StructType\CleanupExpiredAlertsRequest $payload
     * @return \QCC\CampusM\CloudService\StructType\CleanupExpiredAlertsResponse|bool
     */
    public function cleanupExpiredAlerts(\QCC\CampusM\CloudService\StructType\CleanupExpiredAlertsRequest $payload)
    {
        try {
            $this->setResult(self::getSoapClient()->cleanupExpiredAlerts($payload));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \QCC\CampusM\CloudService\StructType\CleanupExpiredAlertsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
