<?php

namespace QCC\CampusM\CloudService\EnumType;

/**
 * This class stands for PlatformType EnumType
 * @subpackage Enumerations
 */
class PlatformType
{
    /**
     * Constant for value 'ios'
     * @return string 'ios'
     */
    const VALUE_IOS = 'ios';
    /**
     * Constant for value 'IOS'
     * @return string 'IOS'
     */
    const VALUE_IOS_1 = 'IOS';
    /**
     * Constant for value 'android'
     * @return string 'android'
     */
    const VALUE_ANDROID = 'android';
    /**
     * Constant for value 'ANDROID'
     * @return string 'ANDROID'
     */
    const VALUE_ANDROID_1 = 'ANDROID';
    /**
     * Constant for value 'rim'
     * @return string 'rim'
     */
    const VALUE_RIM = 'rim';
    /**
     * Constant for value 'RIM'
     * @return string 'RIM'
     */
    const VALUE_RIM_1 = 'RIM';
    /**
     * Constant for value 'web'
     * @return string 'web'
     */
    const VALUE_WEB = 'web';
    /**
     * Constant for value 'WEB'
     * @return string 'WEB'
     */
    const VALUE_WEB_1 = 'WEB';
    /**
     * Constant for value 'web2'
     * @return string 'web2'
     */
    const VALUE_WEB_2 = 'web2';
    /**
     * Constant for value 'WEB2'
     * @return string 'WEB2'
     */
    const VALUE_WEB_2_1 = 'WEB2';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_IOS
     * @uses self::VALUE_IOS_1
     * @uses self::VALUE_ANDROID
     * @uses self::VALUE_ANDROID_1
     * @uses self::VALUE_RIM
     * @uses self::VALUE_RIM_1
     * @uses self::VALUE_WEB
     * @uses self::VALUE_WEB_1
     * @uses self::VALUE_WEB_2
     * @uses self::VALUE_WEB_2_1
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_IOS,
            self::VALUE_IOS_1,
            self::VALUE_ANDROID,
            self::VALUE_ANDROID_1,
            self::VALUE_RIM,
            self::VALUE_RIM_1,
            self::VALUE_WEB,
            self::VALUE_WEB_1,
            self::VALUE_WEB_2,
            self::VALUE_WEB_2_1,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
