<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.ombielservices.co.uk/axis2v3/services/CampusMService?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.ombielservices.co.uk/axis2v3/services/CampusMService?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \QCC\CampusM\CloudService\ClassMap::get(),
);
/**
 * Samples for User ServiceType
 */
$user = new \QCC\CampusM\CloudService\ServiceType\User($options);
/**
 * Sample call for userDetailService operation/method
 */
if ($user->userDetailService(new \QCC\CampusM\CloudService\StructType\UserDetailRequest()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userLogin operation/method
 */
if ($user->userLogin(new \QCC\CampusM\CloudService\StructType\UserLoginRequest()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userLoginLDAP operation/method
 */
if ($user->userLoginLDAP(new \QCC\CampusM\CloudService\StructType\UserLoginLDAPRequest()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userLoginOAuth operation/method
 */
if ($user->userLoginOAuth(new \QCC\CampusM\CloudService\StructType\UserLoginOAuthRequest()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \QCC\CampusM\CloudService\ServiceType\Update($options);
/**
 * Sample call for updateUserDetailService operation/method
 */
if ($update->updateUserDetailService(new \QCC\CampusM\CloudService\StructType\UpdateUserDetailRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateDirectoryList operation/method
 */
if ($update->updateDirectoryList(new \QCC\CampusM\CloudService\StructType\UpdateDirectoryListRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateMenu operation/method
 */
if ($update->updateMenu(new \QCC\CampusM\CloudService\StructType\UpdateMenuRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateMyLocation operation/method
 */
if ($update->updateMyLocation(new \QCC\CampusM\CloudService\StructType\UpdateMyLocationRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateRssSubs operation/method
 */
if ($update->updateRssSubs(new \QCC\CampusM\CloudService\StructType\UpdateRssSubsRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateAlertSubscriptions operation/method
 */
if ($update->updateAlertSubscriptions(new \QCC\CampusM\CloudService\StructType\UpdateAlertSubscriptionsRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateDistanceSetting operation/method
 */
if ($update->updateDistanceSetting(new \QCC\CampusM\CloudService\StructType\UpdateDistanceSettingRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateFavourites operation/method
 */
if ($update->updateFavourites(new \QCC\CampusM\CloudService\StructType\UpdateFavouritesRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateFriends operation/method
 */
if ($update->updateFriends(new \QCC\CampusM\CloudService\StructType\UpdateFriendsRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updatePerson operation/method
 */
if ($update->updatePerson(new \QCC\CampusM\CloudService\StructType\UpdatePerson()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updatePositionNotes operation/method
 */
if ($update->updatePositionNotes(new \QCC\CampusM\CloudService\StructType\UpdatePositionNotes()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateFeedsData operation/method
 */
if ($update->updateFeedsData(new \QCC\CampusM\CloudService\StructType\UpdateFeedsDataRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Save ServiceType
 */
$save = new \QCC\CampusM\CloudService\ServiceType\Save($options);
/**
 * Sample call for saveJobPreferencesService operation/method
 */
if ($save->saveJobPreferencesService(new \QCC\CampusM\CloudService\StructType\SaveJobPreferences()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Sample call for saveJobVacanciesService operation/method
 */
if ($save->saveJobVacanciesService(new \QCC\CampusM\CloudService\StructType\SaveJobVacancies()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \QCC\CampusM\CloudService\ServiceType\Get($options);
/**
 * Sample call for getJobPreferencesService operation/method
 */
if ($get->getJobPreferencesService(new \QCC\CampusM\CloudService\StructType\GetJobPreferences()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCurrentProfile operation/method
 */
if ($get->getCurrentProfile(new \QCC\CampusM\CloudService\StructType\GetCurrentProfileRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getResources operation/method
 */
if ($get->getResources(new \QCC\CampusM\CloudService\StructType\GetResourcesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRefLookups operation/method
 */
if ($get->getRefLookups(new \QCC\CampusM\CloudService\StructType\GetRefLookupsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFeedItems operation/method
 */
if ($get->getFeedItems(new \QCC\CampusM\CloudService\StructType\GetFeedItemsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPersonalisationConfig operation/method
 */
if ($get->getPersonalisationConfig(new \QCC\CampusM\CloudService\StructType\GetPersonalisationConfigRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \QCC\CampusM\CloudService\ServiceType\Send($options);
/**
 * Sample call for sendJobAlertsService operation/method
 */
if ($send->sendJobAlertsService(new \QCC\CampusM\CloudService\StructType\SendJobAlerts()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendSchoolAlertsService operation/method
 */
if ($send->sendSchoolAlertsService(new \QCC\CampusM\CloudService\StructType\SendSchoolAlerts()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendNotifications operation/method
 */
if ($send->sendNotifications(new \QCC\CampusM\CloudService\StructType\SendNotificationsRequest()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendAlerts operation/method
 */
if ($send->sendAlerts(new \QCC\CampusM\CloudService\StructType\SendAlertsRequest()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendAlertEmails operation/method
 */
if ($send->sendAlertEmails(new \QCC\CampusM\CloudService\StructType\SendAlertEmailsRequest()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendIntegratedAlerts operation/method
 */
if ($send->sendIntegratedAlerts(new \QCC\CampusM\CloudService\StructType\SendIntegratedAlertsRequest()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for sendRssAlertsService operation/method
 */
if ($send->sendRssAlertsService(new \QCC\CampusM\CloudService\StructType\SendRssAlerts()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Search ServiceType
 */
$search = new \QCC\CampusM\CloudService\ServiceType\Search($options);
/**
 * Sample call for searchJobVacanciesService operation/method
 */
if ($search->searchJobVacanciesService(new \QCC\CampusM\CloudService\StructType\SearchJobVacancies()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for searchDirectoryList operation/method
 */
if ($search->searchDirectoryList(new \QCC\CampusM\CloudService\StructType\SearchDirectoryListRequest()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for searchDirList operation/method
 */
if ($search->searchDirList(new \QCC\CampusM\CloudService\StructType\SearchDirListRequest()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for searchPosition operation/method
 */
if ($search->searchPosition(new \QCC\CampusM\CloudService\StructType\SearchPositionRequest()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for searchPerson operation/method
 */
if ($search->searchPerson(new \QCC\CampusM\CloudService\StructType\SearchPersonRequest()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Samples for Remove ServiceType
 */
$remove = new \QCC\CampusM\CloudService\ServiceType\Remove($options);
/**
 * Sample call for removePersonRoles operation/method
 */
if ($remove->removePersonRoles(new \QCC\CampusM\CloudService\StructType\RemovePersonRolesRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \QCC\CampusM\CloudService\ServiceType\Create($options);
/**
 * Sample call for createStudent operation/method
 */
if ($create->createStudent(new \QCC\CampusM\CloudService\StructType\CreateStudentRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Insert ServiceType
 */
$insert = new \QCC\CampusM\CloudService\ServiceType\Insert($options);
/**
 * Sample call for insertXml operation/method
 */
if ($insert->insertXml(new \QCC\CampusM\CloudService\StructType\InsertXmlRequest()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for insertDirectoryList operation/method
 */
if ($insert->insertDirectoryList(new \QCC\CampusM\CloudService\StructType\InsertDirectoryListRequest()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Samples for Delegate ServiceType
 */
$delegate = new \QCC\CampusM\CloudService\ServiceType\Delegate($options);
/**
 * Sample call for delegateDir operation/method
 */
if ($delegate->delegateDir(new \QCC\CampusM\CloudService\StructType\DelegateDirRequest()) !== false) {
    print_r($delegate->getResult());
} else {
    print_r($delegate->getLastError());
}
/**
 * Sample call for delegateDetails operation/method
 */
if ($delegate->delegateDetails(new \QCC\CampusM\CloudService\StructType\DelegateDetailsRequest()) !== false) {
    print_r($delegate->getResult());
} else {
    print_r($delegate->getLastError());
}
/**
 * Samples for Directory ServiceType
 */
$directory = new \QCC\CampusM\CloudService\ServiceType\Directory($options);
/**
 * Sample call for directoryList operation/method
 */
if ($directory->directoryList(new \QCC\CampusM\CloudService\StructType\DirectoryListRequest()) !== false) {
    print_r($directory->getResult());
} else {
    print_r($directory->getLastError());
}
/**
 * Samples for Dir ServiceType
 */
$dir = new \QCC\CampusM\CloudService\ServiceType\Dir($options);
/**
 * Sample call for dirList operation/method
 */
if ($dir->dirList(new \QCC\CampusM\CloudService\StructType\DirListRequest()) !== false) {
    print_r($dir->getResult());
} else {
    print_r($dir->getLastError());
}
/**
 * Samples for Host ServiceType
 */
$host = new \QCC\CampusM\CloudService\ServiceType\Host($options);
/**
 * Sample call for hostConfig operation/method
 */
if ($host->hostConfig(new \QCC\CampusM\CloudService\StructType\HostConfigRequest()) !== false) {
    print_r($host->getResult());
} else {
    print_r($host->getLastError());
}
/**
 * Samples for Reg ServiceType
 */
$reg = new \QCC\CampusM\CloudService\ServiceType\Reg($options);
/**
 * Sample call for regProcess operation/method
 */
if ($reg->regProcess(new \QCC\CampusM\CloudService\StructType\RegProcessRequest()) !== false) {
    print_r($reg->getResult());
} else {
    print_r($reg->getLastError());
}
/**
 * Samples for Result ServiceType
 */
$result = new \QCC\CampusM\CloudService\ServiceType\Result($options);
/**
 * Sample call for resultUrl operation/method
 */
if ($result->resultUrl(new \QCC\CampusM\CloudService\StructType\VoteResultUrlRequest()) !== false) {
    print_r($result->getResult());
} else {
    print_r($result->getLastError());
}
/**
 * Samples for MEPS ServiceType
 */
$mEPS = new \QCC\CampusM\CloudService\ServiceType\MEPS($options);
/**
 * Sample call for MEPStartup operation/method
 */
if ($mEPS->MEPStartup(new \QCC\CampusM\CloudService\StructType\StartupMEPRequest()) !== false) {
    print_r($mEPS->getResult());
} else {
    print_r($mEPS->getLastError());
}
/**
 * Samples for Startup ServiceType
 */
$startup = new \QCC\CampusM\CloudService\ServiceType\Startup($options);
/**
 * Sample call for startup operation/method
 */
if ($startup->startup(new \QCC\CampusM\CloudService\StructType\StartupRequest()) !== false) {
    print_r($startup->getResult());
} else {
    print_r($startup->getLastError());
}
/**
 * Samples for Aek ServiceType
 */
$aek = new \QCC\CampusM\CloudService\ServiceType\Aek($options);
/**
 * Sample call for aekPage operation/method
 */
if ($aek->aekPage(new \QCC\CampusM\CloudService\StructType\AekPageRequest()) !== false) {
    print_r($aek->getResult());
} else {
    print_r($aek->getLastError());
}
/**
 * Samples for Retrieve ServiceType
 */
$retrieve = new \QCC\CampusM\CloudService\ServiceType\Retrieve($options);
/**
 * Sample call for retrieveRssHeaderItems operation/method
 */
if ($retrieve->retrieveRssHeaderItems(new \QCC\CampusM\CloudService\StructType\RetrieveRssHeaderItemsRequest()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for retrieveAlertSubscriptions operation/method
 */
if ($retrieve->retrieveAlertSubscriptions(new \QCC\CampusM\CloudService\StructType\RetrieveAlertSubscriptionsRequest()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for retrieveFavourites operation/method
 */
if ($retrieve->retrieveFavourites(new \QCC\CampusM\CloudService\StructType\RetrieveFavouritesRequest()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for retrievePosition operation/method
 */
if ($retrieve->retrievePosition(new \QCC\CampusM\CloudService\StructType\RetrievePosition()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Samples for Base ServiceType
 */
$base = new \QCC\CampusM\CloudService\ServiceType\Base($options);
/**
 * Sample call for base64 operation/method
 */
if ($base->base64(new \QCC\CampusM\CloudService\StructType\Base64Request()) !== false) {
    print_r($base->getResult());
} else {
    print_r($base->getLastError());
}
/**
 * Samples for Cleanup ServiceType
 */
$cleanup = new \QCC\CampusM\CloudService\ServiceType\Cleanup($options);
/**
 * Sample call for cleanupExpiredAlerts operation/method
 */
if ($cleanup->cleanupExpiredAlerts(new \QCC\CampusM\CloudService\StructType\CleanupExpiredAlertsRequest()) !== false) {
    print_r($cleanup->getResult());
} else {
    print_r($cleanup->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \QCC\CampusM\CloudService\ServiceType\Delete($options);
/**
 * Sample call for deleteUser operation/method
 */
if ($delete->deleteUser(new \QCC\CampusM\CloudService\StructType\DeleteUserRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteAlerts operation/method
 */
if ($delete->deleteAlerts(new \QCC\CampusM\CloudService\StructType\DeleteAlertsRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Enter ServiceType
 */
$enter = new \QCC\CampusM\CloudService\ServiceType\Enter($options);
/**
 * Sample call for enterProfile operation/method
 */
if ($enter->enterProfile(new \QCC\CampusM\CloudService\StructType\EnterProfileRequest()) !== false) {
    print_r($enter->getResult());
} else {
    print_r($enter->getLastError());
}
/**
 * Samples for Test ServiceType
 */
$test = new \QCC\CampusM\CloudService\ServiceType\Test($options);
/**
 * Sample call for testUserLogin operation/method
 */
if ($test->testUserLogin(new \QCC\CampusM\CloudService\StructType\Login()) !== false) {
    print_r($test->getResult());
} else {
    print_r($test->getLastError());
}
/**
 * Sample call for testAsync operation/method
 */
if ($test->testAsync(new \QCC\CampusM\CloudService\StructType\TestAsyncRequest()) !== false) {
    print_r($test->getResult());
} else {
    print_r($test->getLastError());
}
/**
 * Samples for Pocket ServiceType
 */
$pocket = new \QCC\CampusM\CloudService\ServiceType\Pocket($options);
/**
 * Sample call for pocketGuideContent operation/method
 */
if ($pocket->pocketGuideContent(new \QCC\CampusM\CloudService\StructType\PocketGuideContentRequest()) !== false) {
    print_r($pocket->getResult());
} else {
    print_r($pocket->getLastError());
}
/**
 * Sample call for pocketGuide operation/method
 */
if ($pocket->pocketGuide(new \QCC\CampusM\CloudService\StructType\PocketGuide()) !== false) {
    print_r($pocket->getResult());
} else {
    print_r($pocket->getLastError());
}
/**
 * Samples for Org ServiceType
 */
$org = new \QCC\CampusM\CloudService\ServiceType\Org($options);
/**
 * Sample call for orgUsers operation/method
 */
if ($org->orgUsers(new \QCC\CampusM\CloudService\StructType\OrgUsersRequest()) !== false) {
    print_r($org->getResult());
} else {
    print_r($org->getLastError());
}
/**
 * Samples for App ServiceType
 */
$app = new \QCC\CampusM\CloudService\ServiceType\App($options);
/**
 * Sample call for appUsers operation/method
 */
if ($app->appUsers(new \QCC\CampusM\CloudService\StructType\AppUsersRequest()) !== false) {
    print_r($app->getResult());
} else {
    print_r($app->getLastError());
}
/**
 * Sample call for appDirectoryLogin operation/method
 */
if ($app->appDirectoryLogin(new \QCC\CampusM\CloudService\StructType\AppDirectoryLoginRequest()) !== false) {
    print_r($app->getResult());
} else {
    print_r($app->getLastError());
}
/**
 * Samples for Setup ServiceType
 */
$setup = new \QCC\CampusM\CloudService\ServiceType\Setup($options);
/**
 * Sample call for setupUser operation/method
 */
if ($setup->setupUser(new \QCC\CampusM\CloudService\StructType\SetupUserRequest()) !== false) {
    print_r($setup->getResult());
} else {
    print_r($setup->getLastError());
}
/**
 * Sample call for setupCouncilAlerts operation/method
 */
if ($setup->setupCouncilAlerts(new \QCC\CampusM\CloudService\StructType\SetupCouncilAlertsRequest()) !== false) {
    print_r($setup->getResult());
} else {
    print_r($setup->getLastError());
}
/**
 * Samples for OA ServiceType
 */
$oA = new \QCC\CampusM\CloudService\ServiceType\OA($options);
/**
 * Sample call for oAuthToken operation/method
 */
if ($oA->oAuthToken(new \QCC\CampusM\CloudService\StructType\OAuthTokenRequest()) !== false) {
    print_r($oA->getResult());
} else {
    print_r($oA->getLastError());
}
/**
 * Sample call for oAuthRefresh operation/method
 */
if ($oA->oAuthRefresh(new \QCC\CampusM\CloudService\StructType\OAuthRefreshRequest()) !== false) {
    print_r($oA->getResult());
} else {
    print_r($oA->getLastError());
}
/**
 * Samples for Validate ServiceType
 */
$validate = new \QCC\CampusM\CloudService\ServiceType\Validate($options);
/**
 * Sample call for validateUser operation/method
 */
if ($validate->validateUser(new \QCC\CampusM\CloudService\StructType\ValidateUserRequest()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \QCC\CampusM\CloudService\ServiceType\Set($options);
/**
 * Sample call for setAppServerPassword operation/method
 */
if ($set->setAppServerPassword(new \QCC\CampusM\CloudService\StructType\SetAppServerPasswordRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setPersonPassword operation/method
 */
if ($set->setPersonPassword(new \QCC\CampusM\CloudService\StructType\SetPersonPasswordRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setRolesUpdated operation/method
 */
if ($set->setRolesUpdated(new \QCC\CampusM\CloudService\StructType\SetRolesUpdatedRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setPersonalisationConfig operation/method
 */
if ($set->setPersonalisationConfig(new \QCC\CampusM\CloudService\StructType\SetPersonalisationConfigRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Facebook ServiceType
 */
$facebook = new \QCC\CampusM\CloudService\ServiceType\Facebook($options);
/**
 * Sample call for facebookPostAuthorize operation/method
 */
if ($facebook->facebookPostAuthorize(new \QCC\CampusM\CloudService\StructType\FacebookPostAuthorizeRequest()) !== false) {
    print_r($facebook->getResult());
} else {
    print_r($facebook->getLastError());
}
/**
 * Sample call for facebookPostRemove operation/method
 */
if ($facebook->facebookPostRemove(new \QCC\CampusM\CloudService\StructType\FacebookPostRemoveRequest()) !== false) {
    print_r($facebook->getResult());
} else {
    print_r($facebook->getLastError());
}
/**
 * Samples for View ServiceType
 */
$view = new \QCC\CampusM\CloudService\ServiceType\View($options);
/**
 * Sample call for viewAlerts operation/method
 */
if ($view->viewAlerts(new \QCC\CampusM\CloudService\StructType\ViewAlertsRequest()) !== false) {
    print_r($view->getResult());
} else {
    print_r($view->getLastError());
}
/**
 * Samples for Read ServiceType
 */
$read = new \QCC\CampusM\CloudService\ServiceType\Read($options);
/**
 * Sample call for readAlerts operation/method
 */
if ($read->readAlerts(new \QCC\CampusM\CloudService\StructType\ReadAlertsRequest()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Samples for My ServiceType
 */
$my = new \QCC\CampusM\CloudService\ServiceType\My($options);
/**
 * Sample call for myLocationOptions operation/method
 */
if ($my->myLocationOptions(new \QCC\CampusM\CloudService\StructType\MyLocationOptionsRequest()) !== false) {
    print_r($my->getResult());
} else {
    print_r($my->getLastError());
}
/**
 * Sample call for myDetail operation/method
 */
if ($my->myDetail(new \QCC\CampusM\CloudService\StructType\MyDetailRequest()) !== false) {
    print_r($my->getResult());
} else {
    print_r($my->getLastError());
}
/**
 * Samples for Find ServiceType
 */
$find = new \QCC\CampusM\CloudService\ServiceType\Find($options);
/**
 * Sample call for findFriends operation/method
 */
if ($find->findFriends(new \QCC\CampusM\CloudService\StructType\FindFriendsRequest()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findPositions operation/method
 */
if ($find->findPositions(new \QCC\CampusM\CloudService\StructType\FindPositionsRequest()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \QCC\CampusM\CloudService\ServiceType\Check($options);
/**
 * Sample call for checkInLocations operation/method
 */
if ($check->checkInLocations(new \QCC\CampusM\CloudService\StructType\CheckInLocationsRequest()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for checkActivatedEmails operation/method
 */
if ($check->checkActivatedEmails(new \QCC\CampusM\CloudService\StructType\CheckActivatedEmailsRequest()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for News ServiceType
 */
$news = new \QCC\CampusM\CloudService\ServiceType\News($options);
/**
 * Sample call for newsEvents operation/method
 */
if ($news->newsEvents(new \QCC\CampusM\CloudService\StructType\NewsEventsRequest()) !== false) {
    print_r($news->getResult());
} else {
    print_r($news->getLastError());
}
/**
 * Samples for List ServiceType
 */
$list = new \QCC\CampusM\CloudService\ServiceType\_List($options);
/**
 * Sample call for listAvailableFeeds operation/method
 */
if ($list->listAvailableFeeds(new \QCC\CampusM\CloudService\StructType\ListAvailableFeedsRequest()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listAvailableProfiles operation/method
 */
if ($list->listAvailableProfiles(new \QCC\CampusM\CloudService\StructType\ListAvailableProfilesRequest()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listAvailableOrganisations operation/method
 */
if ($list->listAvailableOrganisations(new \QCC\CampusM\CloudService\StructType\ListAvailableOrganisationsRequest()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listQuestions operation/method
 */
if ($list->listQuestions(new \QCC\CampusM\CloudService\StructType\ListQuestions()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listVoteCategories operation/method
 */
if ($list->listVoteCategories(new \QCC\CampusM\CloudService\StructType\ListVoteCategories()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Samples for Location ServiceType
 */
$location = new \QCC\CampusM\CloudService\ServiceType\Location($options);
/**
 * Sample call for locationCategories operation/method
 */
if ($location->locationCategories(new \QCC\CampusM\CloudService\StructType\LocationCategoriesRequest()) !== false) {
    print_r($location->getResult());
} else {
    print_r($location->getLastError());
}
/**
 * Sample call for locationList operation/method
 */
if ($location->locationList(new \QCC\CampusM\CloudService\StructType\LocationListRequest()) !== false) {
    print_r($location->getResult());
} else {
    print_r($location->getLastError());
}
/**
 * Samples for Cached ServiceType
 */
$cached = new \QCC\CampusM\CloudService\ServiceType\Cached($options);
/**
 * Sample call for cachedMapPosition operation/method
 */
if ($cached->cachedMapPosition(new \QCC\CampusM\CloudService\StructType\CachedMapPositionRequest()) !== false) {
    print_r($cached->getResult());
} else {
    print_r($cached->getLastError());
}
/**
 * Sample call for cachedPocketGuide operation/method
 */
if ($cached->cachedPocketGuide(new \QCC\CampusM\CloudService\StructType\CachedPocketGuide()) !== false) {
    print_r($cached->getResult());
} else {
    print_r($cached->getLastError());
}
/**
 * Samples for Position ServiceType
 */
$position = new \QCC\CampusM\CloudService\ServiceType\Position($options);
/**
 * Sample call for positionAction operation/method
 */
if ($position->positionAction(new \QCC\CampusM\CloudService\StructType\PositionActionRequest()) !== false) {
    print_r($position->getResult());
} else {
    print_r($position->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \QCC\CampusM\CloudService\ServiceType\Add($options);
/**
 * Sample call for addFriend operation/method
 */
if ($add->addFriend(new \QCC\CampusM\CloudService\StructType\AddFriendRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addBookmark operation/method
 */
if ($add->addBookmark(new \QCC\CampusM\CloudService\StructType\BookmarkUserRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Splash ServiceType
 */
$splash = new \QCC\CampusM\CloudService\ServiceType\Splash($options);
/**
 * Sample call for splashPage operation/method
 */
if ($splash->splashPage(new \QCC\CampusM\CloudService\StructType\SplashPage()) !== false) {
    print_r($splash->getResult());
} else {
    print_r($splash->getLastError());
}
/**
 * Samples for Southampton ServiceType
 */
$southampton = new \QCC\CampusM\CloudService\ServiceType\Southampton($options);
/**
 * Sample call for southamptonPositions operation/method
 */
if ($southampton->southamptonPositions(new \QCC\CampusM\CloudService\StructType\UpdatePositions()) !== false) {
    print_r($southampton->getResult());
} else {
    print_r($southampton->getLastError());
}
/**
 * Samples for Forgotten ServiceType
 */
$forgotten = new \QCC\CampusM\CloudService\ServiceType\Forgotten($options);
/**
 * Sample call for forgottenPassword operation/method
 */
if ($forgotten->forgottenPassword(new \QCC\CampusM\CloudService\StructType\ForgottenPasswordRequest()) !== false) {
    print_r($forgotten->getResult());
} else {
    print_r($forgotten->getLastError());
}
/**
 * Samples for Vote ServiceType
 */
$vote = new \QCC\CampusM\CloudService\ServiceType\Vote($options);
/**
 * Sample call for voteCsv operation/method
 */
if ($vote->voteCsv(new \QCC\CampusM\CloudService\StructType\VoteCsvRequest()) !== false) {
    print_r($vote->getResult());
} else {
    print_r($vote->getLastError());
}
/**
 * Sample call for voteCsvText operation/method
 */
if ($vote->voteCsvText(new \QCC\CampusM\CloudService\StructType\VoteCsvTextRequest()) !== false) {
    print_r($vote->getResult());
} else {
    print_r($vote->getLastError());
}
/**
 * Sample call for voteResults operation/method
 */
if ($vote->voteResults(new \QCC\CampusM\CloudService\StructType\VoteResults()) !== false) {
    print_r($vote->getResult());
} else {
    print_r($vote->getLastError());
}
/**
 * Samples for Ucisa ServiceType
 */
$ucisa = new \QCC\CampusM\CloudService\ServiceType\Ucisa($options);
/**
 * Sample call for ucisaThingy operation/method
 */
if ($ucisa->ucisaThingy(new \QCC\CampusM\CloudService\StructType\UcisaThingyRequest()) !== false) {
    print_r($ucisa->getResult());
} else {
    print_r($ucisa->getLastError());
}
/**
 * Samples for Person ServiceType
 */
$person = new \QCC\CampusM\CloudService\ServiceType\Person($options);
/**
 * Sample call for person operation/method
 */
if ($person->person(new \QCC\CampusM\CloudService\StructType\Person()) !== false) {
    print_r($person->getResult());
} else {
    print_r($person->getLastError());
}
/**
 * Samples for Submit ServiceType
 */
$submit = new \QCC\CampusM\CloudService\ServiceType\Submit($options);
/**
 * Sample call for submitQuestion operation/method
 */
if ($submit->submitQuestion(new \QCC\CampusM\CloudService\StructType\SubmitQuestion()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for submitUserFeedback operation/method
 */
if ($submit->submitUserFeedback(new \QCC\CampusM\CloudService\StructType\SubmitUserFeedback()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for submitUserIdea operation/method
 */
if ($submit->submitUserIdea(new \QCC\CampusM\CloudService\StructType\SubmitUserIdea()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for submitUserProblem operation/method
 */
if ($submit->submitUserProblem(new \QCC\CampusM\CloudService\StructType\SubmitUserProblem()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for submitIdea operation/method
 */
if ($submit->submitIdea(new \QCC\CampusM\CloudService\StructType\SubmitIdea()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Sample call for submitProblem operation/method
 */
if ($submit->submitProblem(new \QCC\CampusM\CloudService\StructType\SubmitProblem()) !== false) {
    print_r($submit->getResult());
} else {
    print_r($submit->getLastError());
}
/**
 * Samples for Appropriate ServiceType
 */
$appropriate = new \QCC\CampusM\CloudService\ServiceType\Appropriate($options);
/**
 * Sample call for appropriate operation/method
 */
if ($appropriate->appropriate(new \QCC\CampusM\CloudService\StructType\Appropriate()) !== false) {
    print_r($appropriate->getResult());
} else {
    print_r($appropriate->getLastError());
}
/**
 * Samples for Del ServiceType
 */
$del = new \QCC\CampusM\CloudService\ServiceType\Del($options);
/**
 * Sample call for delBookmark operation/method
 */
if ($del->delBookmark(new \QCC\CampusM\CloudService\StructType\DeleteBookmarkRequest()) !== false) {
    print_r($del->getResult());
} else {
    print_r($del->getLastError());
}
/**
 * Samples for Certificate ServiceType
 */
$certificate = new \QCC\CampusM\CloudService\ServiceType\Certificate($options);
/**
 * Sample call for certificateStatus operation/method
 */
if ($certificate->certificateStatus(new \QCC\CampusM\CloudService\StructType\CertificateStatusRequest()) !== false) {
    print_r($certificate->getResult());
} else {
    print_r($certificate->getLastError());
}
/**
 * Samples for Reconfigure ServiceType
 */
$reconfigure = new \QCC\CampusM\CloudService\ServiceType\Reconfigure($options);
/**
 * Sample call for reconfigurePushCentre operation/method
 */
if ($reconfigure->reconfigurePushCentre(new \QCC\CampusM\CloudService\StructType\ReconfigurePushCentreRequest()) !== false) {
    print_r($reconfigure->getResult());
} else {
    print_r($reconfigure->getLastError());
}
/**
 * Samples for Push ServiceType
 */
$push = new \QCC\CampusM\CloudService\ServiceType\Push($options);
/**
 * Sample call for pushCentreStatus operation/method
 */
if ($push->pushCentreStatus(new \QCC\CampusM\CloudService\StructType\PushCentreStatusRequest()) !== false) {
    print_r($push->getResult());
} else {
    print_r($push->getLastError());
}
/**
 * Samples for Report ServiceType
 */
$report = new \QCC\CampusM\CloudService\ServiceType\Report($options);
/**
 * Sample call for reportItOptions operation/method
 */
if ($report->reportItOptions(new \QCC\CampusM\CloudService\StructType\ReportItOptionsRequest()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Samples for Educause ServiceType
 */
$educause = new \QCC\CampusM\CloudService\ServiceType\Educause($options);
/**
 * Sample call for educauseSyncItinerary operation/method
 */
if ($educause->educauseSyncItinerary(new \QCC\CampusM\CloudService\StructType\EducauseSyncItineraryRequest()) !== false) {
    print_r($educause->getResult());
} else {
    print_r($educause->getLastError());
}
/**
 * Samples for Resend ServiceType
 */
$resend = new \QCC\CampusM\CloudService\ServiceType\Resend($options);
/**
 * Sample call for resendActivationEmail operation/method
 */
if ($resend->resendActivationEmail(new \QCC\CampusM\CloudService\StructType\ResendActivationEmailRequest()) !== false) {
    print_r($resend->getResult());
} else {
    print_r($resend->getLastError());
}
/**
 * Samples for Expire ServiceType
 */
$expire = new \QCC\CampusM\CloudService\ServiceType\Expire($options);
/**
 * Sample call for expireFeedsSurveys operation/method
 */
if ($expire->expireFeedsSurveys(new \QCC\CampusM\CloudService\StructType\ExpireFeedsSurveysRequest()) !== false) {
    print_r($expire->getResult());
} else {
    print_r($expire->getLastError());
}
/**
 * Samples for Generate ServiceType
 */
$generate = new \QCC\CampusM\CloudService\ServiceType\Generate($options);
/**
 * Sample call for generateHashService operation/method
 */
if ($generate->generateHashService(new \QCC\CampusM\CloudService\StructType\GenerateHashRequest()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Samples for Deactivate ServiceType
 */
$deactivate = new \QCC\CampusM\CloudService\ServiceType\Deactivate($options);
/**
 * Sample call for deactivateOldDevicesService operation/method
 */
if ($deactivate->deactivateOldDevicesService(new \QCC\CampusM\CloudService\StructType\DeactivateOldDevicesRequest()) !== false) {
    print_r($deactivate->getResult());
} else {
    print_r($deactivate->getLastError());
}
/**
 * Samples for Insight ServiceType
 */
$insight = new \QCC\CampusM\CloudService\ServiceType\Insight($options);
/**
 * Sample call for insightCaptureService operation/method
 */
if ($insight->insightCaptureService(new \QCC\CampusM\CloudService\StructType\InsightCaptureServiceRequest()) !== false) {
    print_r($insight->getResult());
} else {
    print_r($insight->getLastError());
}
