<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for voteCsvTextRequest StructType
 * @subpackage Structs
 */
class VoteCsvTextRequest extends AbstractStructBase
{
    /**
     * The orgCode
     * @var int
     */
    public $orgCode;
    /**
     * The orgServicePassword
     * @var string
     */
    public $orgServicePassword;
    /**
     * The emailAddress
     * @var string
     */
    public $emailAddress;
    /**
     * The minQuestionCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $minQuestionCode;
    /**
     * The maxQuestionCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $maxQuestionCode;
    /**
     * Constructor method for voteCsvTextRequest
     * @uses VoteCsvTextRequest::setOrgCode()
     * @uses VoteCsvTextRequest::setOrgServicePassword()
     * @uses VoteCsvTextRequest::setEmailAddress()
     * @uses VoteCsvTextRequest::setMinQuestionCode()
     * @uses VoteCsvTextRequest::setMaxQuestionCode()
     * @param int $orgCode
     * @param string $orgServicePassword
     * @param string $emailAddress
     * @param int $minQuestionCode
     * @param int $maxQuestionCode
     */
    public function __construct($orgCode = null, $orgServicePassword = null, $emailAddress = null, $minQuestionCode = null, $maxQuestionCode = null)
    {
        $this
            ->setOrgCode($orgCode)
            ->setOrgServicePassword($orgServicePassword)
            ->setEmailAddress($emailAddress)
            ->setMinQuestionCode($minQuestionCode)
            ->setMaxQuestionCode($maxQuestionCode);
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\VoteCsvTextRequest
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get orgServicePassword value
     * @return string|null
     */
    public function getOrgServicePassword()
    {
        return $this->orgServicePassword;
    }
    /**
     * Set orgServicePassword value
     * @param string $orgServicePassword
     * @return \QCC\CampusM\CloudService\StructType\VoteCsvTextRequest
     */
    public function setOrgServicePassword($orgServicePassword = null)
    {
        // validation for constraint: string
        if (!is_null($orgServicePassword) && !is_string($orgServicePassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orgServicePassword)), __LINE__);
        }
        $this->orgServicePassword = $orgServicePassword;
        return $this;
    }
    /**
     * Get emailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->emailAddress;
    }
    /**
     * Set emailAddress value
     * @param string $emailAddress
     * @return \QCC\CampusM\CloudService\StructType\VoteCsvTextRequest
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->emailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get minQuestionCode value
     * @return int|null
     */
    public function getMinQuestionCode()
    {
        return $this->minQuestionCode;
    }
    /**
     * Set minQuestionCode value
     * @param int $minQuestionCode
     * @return \QCC\CampusM\CloudService\StructType\VoteCsvTextRequest
     */
    public function setMinQuestionCode($minQuestionCode = null)
    {
        // validation for constraint: int
        if (!is_null($minQuestionCode) && !is_numeric($minQuestionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minQuestionCode)), __LINE__);
        }
        $this->minQuestionCode = $minQuestionCode;
        return $this;
    }
    /**
     * Get maxQuestionCode value
     * @return int|null
     */
    public function getMaxQuestionCode()
    {
        return $this->maxQuestionCode;
    }
    /**
     * Set maxQuestionCode value
     * @param int $maxQuestionCode
     * @return \QCC\CampusM\CloudService\StructType\VoteCsvTextRequest
     */
    public function setMaxQuestionCode($maxQuestionCode = null)
    {
        // validation for constraint: int
        if (!is_null($maxQuestionCode) && !is_numeric($maxQuestionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxQuestionCode)), __LINE__);
        }
        $this->maxQuestionCode = $maxQuestionCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\VoteCsvTextRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
