<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for viewAlertsResponse StructType
 * @subpackage Structs
 */
class ViewAlertsResponse extends AbstractStructBase
{
    /**
     * The timestamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $timestamp;
    /**
     * The alerts
     * @var \QCC\CampusM\CloudService\StructType\Alerts
     */
    public $alerts;
    /**
     * Constructor method for viewAlertsResponse
     * @uses ViewAlertsResponse::setTimestamp()
     * @uses ViewAlertsResponse::setAlerts()
     * @param string $timestamp
     * @param \QCC\CampusM\CloudService\StructType\Alerts $alerts
     */
    public function __construct($timestamp = null, \QCC\CampusM\CloudService\StructType\Alerts $alerts = null)
    {
        $this
            ->setTimestamp($timestamp)
            ->setAlerts($alerts);
    }
    /**
     * Get timestamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTimestamp()
    {
        return isset($this->timestamp) ? $this->timestamp : null;
    }
    /**
     * Set timestamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $timestamp
     * @return \QCC\CampusM\CloudService\StructType\ViewAlertsResponse
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timestamp)), __LINE__);
        }
        if (is_null($timestamp) || (is_array($timestamp) && empty($timestamp))) {
            unset($this->timestamp);
        } else {
            $this->timestamp = $timestamp;
        }
        return $this;
    }
    /**
     * Get alerts value
     * @return \QCC\CampusM\CloudService\StructType\Alerts|null
     */
    public function getAlerts()
    {
        return $this->alerts;
    }
    /**
     * Set alerts value
     * @param \QCC\CampusM\CloudService\StructType\Alerts $alerts
     * @return \QCC\CampusM\CloudService\StructType\ViewAlertsResponse
     */
    public function setAlerts(\QCC\CampusM\CloudService\StructType\Alerts $alerts = null)
    {
        $this->alerts = $alerts;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\ViewAlertsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
