<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for userLoginLDAPResponse StructType
 * @subpackage Structs
 */
class UserLoginLDAPResponse extends AbstractStructBase
{
    /**
     * The personId
     * @var int
     */
    public $personId;
    /**
     * The authToken
     * @var string
     */
    public $authToken;
    /**
     * The firstname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $firstname;
    /**
     * The surname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $surname;
    /**
     * The emailAddress
     * @var string
     */
    public $emailAddress;
    /**
     * The dateRegistered
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateRegistered;
    /**
     * The dateLastLogin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateLastLogin;
    /**
     * The shareLoc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shareLoc;
    /**
     * The updateLoc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $updateLoc;
    /**
     * The roleNames
     * @var \QCC\CampusM\CloudService\StructType\RoleNames
     */
    public $roleNames;
    /**
     * The authedProfileIds
     * @var \QCC\CampusM\CloudService\StructType\ProfileIds
     */
    public $authedProfileIds;
    /**
     * The convertedFromGuest
     * @var bool
     */
    public $convertedFromGuest;
    /**
     * Constructor method for userLoginLDAPResponse
     * @uses UserLoginLDAPResponse::setPersonId()
     * @uses UserLoginLDAPResponse::setAuthToken()
     * @uses UserLoginLDAPResponse::setFirstname()
     * @uses UserLoginLDAPResponse::setSurname()
     * @uses UserLoginLDAPResponse::setEmailAddress()
     * @uses UserLoginLDAPResponse::setDateRegistered()
     * @uses UserLoginLDAPResponse::setDateLastLogin()
     * @uses UserLoginLDAPResponse::setShareLoc()
     * @uses UserLoginLDAPResponse::setUpdateLoc()
     * @uses UserLoginLDAPResponse::setRoleNames()
     * @uses UserLoginLDAPResponse::setAuthedProfileIds()
     * @uses UserLoginLDAPResponse::setConvertedFromGuest()
     * @param int $personId
     * @param string $authToken
     * @param string $firstname
     * @param string $surname
     * @param string $emailAddress
     * @param string $dateRegistered
     * @param string $dateLastLogin
     * @param string $shareLoc
     * @param int $updateLoc
     * @param \QCC\CampusM\CloudService\StructType\RoleNames $roleNames
     * @param \QCC\CampusM\CloudService\StructType\ProfileIds $authedProfileIds
     * @param bool $convertedFromGuest
     */
    public function __construct($personId = null, $authToken = null, $firstname = null, $surname = null, $emailAddress = null, $dateRegistered = null, $dateLastLogin = null, $shareLoc = null, $updateLoc = null, \QCC\CampusM\CloudService\StructType\RoleNames $roleNames = null, \QCC\CampusM\CloudService\StructType\ProfileIds $authedProfileIds = null, $convertedFromGuest = null)
    {
        $this
            ->setPersonId($personId)
            ->setAuthToken($authToken)
            ->setFirstname($firstname)
            ->setSurname($surname)
            ->setEmailAddress($emailAddress)
            ->setDateRegistered($dateRegistered)
            ->setDateLastLogin($dateLastLogin)
            ->setShareLoc($shareLoc)
            ->setUpdateLoc($updateLoc)
            ->setRoleNames($roleNames)
            ->setAuthedProfileIds($authedProfileIds)
            ->setConvertedFromGuest($convertedFromGuest);
    }
    /**
     * Get personId value
     * @return int|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param int $personId
     * @return \QCC\CampusM\CloudService\StructType\UserLoginLDAPResponse
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: int
        if (!is_null($personId) && !is_numeric($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Get authToken value
     * @return string|null
     */
    public function getAuthToken()
    {
        return $this->authToken;
    }
    /**
     * Set authToken value
     * @param string $authToken
     * @return \QCC\CampusM\CloudService\StructType\UserLoginLDAPResponse
     */
    public function setAuthToken($authToken = null)
    {
        // validation for constraint: string
        if (!is_null($authToken) && !is_string($authToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authToken)), __LINE__);
        }
        $this->authToken = $authToken;
        return $this;
    }
    /**
     * Get firstname value
     * @return string|null
     */
    public function getFirstname()
    {
        return $this->firstname;
    }
    /**
     * Set firstname value
     * @param string $firstname
     * @return \QCC\CampusM\CloudService\StructType\UserLoginLDAPResponse
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstname)), __LINE__);
        }
        $this->firstname = $firstname;
        return $this;
    }
    /**
     * Get surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->surname;
    }
    /**
     * Set surname value
     * @param string $surname
     * @return \QCC\CampusM\CloudService\StructType\UserLoginLDAPResponse
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surname)), __LINE__);
        }
        $this->surname = $surname;
        return $this;
    }
    /**
     * Get emailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->emailAddress;
    }
    /**
     * Set emailAddress value
     * @param string $emailAddress
     * @return \QCC\CampusM\CloudService\StructType\UserLoginLDAPResponse
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->emailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get dateRegistered value
     * @return string|null
     */
    public function getDateRegistered()
    {
        return $this->dateRegistered;
    }
    /**
     * Set dateRegistered value
     * @param string $dateRegistered
     * @return \QCC\CampusM\CloudService\StructType\UserLoginLDAPResponse
     */
    public function setDateRegistered($dateRegistered = null)
    {
        // validation for constraint: string
        if (!is_null($dateRegistered) && !is_string($dateRegistered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateRegistered)), __LINE__);
        }
        $this->dateRegistered = $dateRegistered;
        return $this;
    }
    /**
     * Get dateLastLogin value
     * @return string|null
     */
    public function getDateLastLogin()
    {
        return $this->dateLastLogin;
    }
    /**
     * Set dateLastLogin value
     * @param string $dateLastLogin
     * @return \QCC\CampusM\CloudService\StructType\UserLoginLDAPResponse
     */
    public function setDateLastLogin($dateLastLogin = null)
    {
        // validation for constraint: string
        if (!is_null($dateLastLogin) && !is_string($dateLastLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateLastLogin)), __LINE__);
        }
        $this->dateLastLogin = $dateLastLogin;
        return $this;
    }
    /**
     * Get shareLoc value
     * @return string|null
     */
    public function getShareLoc()
    {
        return $this->shareLoc;
    }
    /**
     * Set shareLoc value
     * @param string $shareLoc
     * @return \QCC\CampusM\CloudService\StructType\UserLoginLDAPResponse
     */
    public function setShareLoc($shareLoc = null)
    {
        // validation for constraint: string
        if (!is_null($shareLoc) && !is_string($shareLoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareLoc)), __LINE__);
        }
        $this->shareLoc = $shareLoc;
        return $this;
    }
    /**
     * Get updateLoc value
     * @return int|null
     */
    public function getUpdateLoc()
    {
        return $this->updateLoc;
    }
    /**
     * Set updateLoc value
     * @param int $updateLoc
     * @return \QCC\CampusM\CloudService\StructType\UserLoginLDAPResponse
     */
    public function setUpdateLoc($updateLoc = null)
    {
        // validation for constraint: int
        if (!is_null($updateLoc) && !is_numeric($updateLoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($updateLoc)), __LINE__);
        }
        $this->updateLoc = $updateLoc;
        return $this;
    }
    /**
     * Get roleNames value
     * @return \QCC\CampusM\CloudService\StructType\RoleNames|null
     */
    public function getRoleNames()
    {
        return $this->roleNames;
    }
    /**
     * Set roleNames value
     * @param \QCC\CampusM\CloudService\StructType\RoleNames $roleNames
     * @return \QCC\CampusM\CloudService\StructType\UserLoginLDAPResponse
     */
    public function setRoleNames(\QCC\CampusM\CloudService\StructType\RoleNames $roleNames = null)
    {
        $this->roleNames = $roleNames;
        return $this;
    }
    /**
     * Get authedProfileIds value
     * @return \QCC\CampusM\CloudService\StructType\ProfileIds|null
     */
    public function getAuthedProfileIds()
    {
        return $this->authedProfileIds;
    }
    /**
     * Set authedProfileIds value
     * @param \QCC\CampusM\CloudService\StructType\ProfileIds $authedProfileIds
     * @return \QCC\CampusM\CloudService\StructType\UserLoginLDAPResponse
     */
    public function setAuthedProfileIds(\QCC\CampusM\CloudService\StructType\ProfileIds $authedProfileIds = null)
    {
        $this->authedProfileIds = $authedProfileIds;
        return $this;
    }
    /**
     * Get convertedFromGuest value
     * @return bool|null
     */
    public function getConvertedFromGuest()
    {
        return $this->convertedFromGuest;
    }
    /**
     * Set convertedFromGuest value
     * @param bool $convertedFromGuest
     * @return \QCC\CampusM\CloudService\StructType\UserLoginLDAPResponse
     */
    public function setConvertedFromGuest($convertedFromGuest = null)
    {
        // validation for constraint: boolean
        if (!is_null($convertedFromGuest) && !is_bool($convertedFromGuest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($convertedFromGuest)), __LINE__);
        }
        $this->convertedFromGuest = $convertedFromGuest;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\UserLoginLDAPResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
