<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for userLoginLDAPRequest StructType
 * @subpackage Structs
 */
class UserLoginLDAPRequest extends AbstractStructBase
{
    /**
     * The orgCode
     * @var int
     */
    public $orgCode;
    /**
     * The profileGroupId
     * @var int
     */
    public $profileGroupId;
    /**
     * The username
     * @var string
     */
    public $username;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The platform
     * @var string
     */
    public $platform;
    /**
     * The skipGuestConversionWarning
     * Meta informations extracted from the WSDL
     * - default: false
     * - minOccurs: 0
     * @var bool
     */
    public $skipGuestConversionWarning;
    /**
     * Constructor method for userLoginLDAPRequest
     * @uses UserLoginLDAPRequest::setOrgCode()
     * @uses UserLoginLDAPRequest::setProfileGroupId()
     * @uses UserLoginLDAPRequest::setUsername()
     * @uses UserLoginLDAPRequest::setPassword()
     * @uses UserLoginLDAPRequest::setPlatform()
     * @uses UserLoginLDAPRequest::setSkipGuestConversionWarning()
     * @param int $orgCode
     * @param int $profileGroupId
     * @param string $username
     * @param string $password
     * @param string $platform
     * @param bool $skipGuestConversionWarning
     */
    public function __construct($orgCode = null, $profileGroupId = null, $username = null, $password = null, $platform = null, $skipGuestConversionWarning = false)
    {
        $this
            ->setOrgCode($orgCode)
            ->setProfileGroupId($profileGroupId)
            ->setUsername($username)
            ->setPassword($password)
            ->setPlatform($platform)
            ->setSkipGuestConversionWarning($skipGuestConversionWarning);
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\UserLoginLDAPRequest
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get profileGroupId value
     * @return int|null
     */
    public function getProfileGroupId()
    {
        return $this->profileGroupId;
    }
    /**
     * Set profileGroupId value
     * @param int $profileGroupId
     * @return \QCC\CampusM\CloudService\StructType\UserLoginLDAPRequest
     */
    public function setProfileGroupId($profileGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($profileGroupId) && !is_numeric($profileGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($profileGroupId)), __LINE__);
        }
        $this->profileGroupId = $profileGroupId;
        return $this;
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \QCC\CampusM\CloudService\StructType\UserLoginLDAPRequest
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \QCC\CampusM\CloudService\StructType\UserLoginLDAPRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get platform value
     * @return string|null
     */
    public function getPlatform()
    {
        return $this->platform;
    }
    /**
     * Set platform value
     * @uses \QCC\CampusM\CloudService\EnumType\PlatformType::valueIsValid()
     * @uses \QCC\CampusM\CloudService\EnumType\PlatformType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $platform
     * @return \QCC\CampusM\CloudService\StructType\UserLoginLDAPRequest
     */
    public function setPlatform($platform = null)
    {
        // validation for constraint: enumeration
        if (!\QCC\CampusM\CloudService\EnumType\PlatformType::valueIsValid($platform)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $platform, implode(', ', \QCC\CampusM\CloudService\EnumType\PlatformType::getValidValues())), __LINE__);
        }
        $this->platform = $platform;
        return $this;
    }
    /**
     * Get skipGuestConversionWarning value
     * @return bool|null
     */
    public function getSkipGuestConversionWarning()
    {
        return $this->skipGuestConversionWarning;
    }
    /**
     * Set skipGuestConversionWarning value
     * @param bool $skipGuestConversionWarning
     * @return \QCC\CampusM\CloudService\StructType\UserLoginLDAPRequest
     */
    public function setSkipGuestConversionWarning($skipGuestConversionWarning = false)
    {
        // validation for constraint: boolean
        if (!is_null($skipGuestConversionWarning) && !is_bool($skipGuestConversionWarning)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($skipGuestConversionWarning)), __LINE__);
        }
        $this->skipGuestConversionWarning = $skipGuestConversionWarning;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\UserLoginLDAPRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
