<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateMyLocationRequest StructType
 * @subpackage Structs
 */
class UpdateMyLocationRequest extends AbstractStructBase
{
    /**
     * The personId
     * @var int
     */
    public $personId;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The gpsUpd
     * @var string
     */
    public $gpsUpd;
    /**
     * The latitude
     * @var float
     */
    public $latitude;
    /**
     * The longitude
     * @var float
     */
    public $longitude;
    /**
     * The altitude
     * @var int
     */
    public $altitude;
    /**
     * The accuracy
     * @var int
     */
    public $accuracy;
    /**
     * The altitudeAccuracy
     * @var int
     */
    public $altitudeAccuracy;
    /**
     * The heading
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $heading;
    /**
     * The speed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $speed;
    /**
     * The lastComment
     * @var string
     */
    public $lastComment;
    /**
     * The lastImage
     * @var string
     */
    public $lastImage;
    /**
     * The checkInLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $checkInLocation;
    /**
     * The checkInPositionId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $checkInPositionId;
    /**
     * The checkInFavourite
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $checkInFavourite;
    /**
     * Constructor method for updateMyLocationRequest
     * @uses UpdateMyLocationRequest::setPersonId()
     * @uses UpdateMyLocationRequest::setPassword()
     * @uses UpdateMyLocationRequest::setGpsUpd()
     * @uses UpdateMyLocationRequest::setLatitude()
     * @uses UpdateMyLocationRequest::setLongitude()
     * @uses UpdateMyLocationRequest::setAltitude()
     * @uses UpdateMyLocationRequest::setAccuracy()
     * @uses UpdateMyLocationRequest::setAltitudeAccuracy()
     * @uses UpdateMyLocationRequest::setHeading()
     * @uses UpdateMyLocationRequest::setSpeed()
     * @uses UpdateMyLocationRequest::setLastComment()
     * @uses UpdateMyLocationRequest::setLastImage()
     * @uses UpdateMyLocationRequest::setCheckInLocation()
     * @uses UpdateMyLocationRequest::setCheckInPositionId()
     * @uses UpdateMyLocationRequest::setCheckInFavourite()
     * @param int $personId
     * @param string $password
     * @param string $gpsUpd
     * @param float $latitude
     * @param float $longitude
     * @param int $altitude
     * @param int $accuracy
     * @param int $altitudeAccuracy
     * @param string $heading
     * @param int $speed
     * @param string $lastComment
     * @param string $lastImage
     * @param string $checkInLocation
     * @param int $checkInPositionId
     * @param string $checkInFavourite
     */
    public function __construct($personId = null, $password = null, $gpsUpd = null, $latitude = null, $longitude = null, $altitude = null, $accuracy = null, $altitudeAccuracy = null, $heading = null, $speed = null, $lastComment = null, $lastImage = null, $checkInLocation = null, $checkInPositionId = null, $checkInFavourite = null)
    {
        $this
            ->setPersonId($personId)
            ->setPassword($password)
            ->setGpsUpd($gpsUpd)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setAltitude($altitude)
            ->setAccuracy($accuracy)
            ->setAltitudeAccuracy($altitudeAccuracy)
            ->setHeading($heading)
            ->setSpeed($speed)
            ->setLastComment($lastComment)
            ->setLastImage($lastImage)
            ->setCheckInLocation($checkInLocation)
            ->setCheckInPositionId($checkInPositionId)
            ->setCheckInFavourite($checkInFavourite);
    }
    /**
     * Get personId value
     * @return int|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param int $personId
     * @return \QCC\CampusM\CloudService\StructType\UpdateMyLocationRequest
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: int
        if (!is_null($personId) && !is_numeric($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \QCC\CampusM\CloudService\StructType\UpdateMyLocationRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get gpsUpd value
     * @return string|null
     */
    public function getGpsUpd()
    {
        return $this->gpsUpd;
    }
    /**
     * Set gpsUpd value
     * @param string $gpsUpd
     * @return \QCC\CampusM\CloudService\StructType\UpdateMyLocationRequest
     */
    public function setGpsUpd($gpsUpd = null)
    {
        // validation for constraint: string
        if (!is_null($gpsUpd) && !is_string($gpsUpd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gpsUpd)), __LINE__);
        }
        $this->gpsUpd = $gpsUpd;
        return $this;
    }
    /**
     * Get latitude value
     * @return float|null
     */
    public function getLatitude()
    {
        return $this->latitude;
    }
    /**
     * Set latitude value
     * @param float $latitude
     * @return \QCC\CampusM\CloudService\StructType\UpdateMyLocationRequest
     */
    public function setLatitude($latitude = null)
    {
        $this->latitude = $latitude;
        return $this;
    }
    /**
     * Get longitude value
     * @return float|null
     */
    public function getLongitude()
    {
        return $this->longitude;
    }
    /**
     * Set longitude value
     * @param float $longitude
     * @return \QCC\CampusM\CloudService\StructType\UpdateMyLocationRequest
     */
    public function setLongitude($longitude = null)
    {
        $this->longitude = $longitude;
        return $this;
    }
    /**
     * Get altitude value
     * @return int|null
     */
    public function getAltitude()
    {
        return $this->altitude;
    }
    /**
     * Set altitude value
     * @param int $altitude
     * @return \QCC\CampusM\CloudService\StructType\UpdateMyLocationRequest
     */
    public function setAltitude($altitude = null)
    {
        // validation for constraint: int
        if (!is_null($altitude) && !is_numeric($altitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($altitude)), __LINE__);
        }
        $this->altitude = $altitude;
        return $this;
    }
    /**
     * Get accuracy value
     * @return int|null
     */
    public function getAccuracy()
    {
        return $this->accuracy;
    }
    /**
     * Set accuracy value
     * @param int $accuracy
     * @return \QCC\CampusM\CloudService\StructType\UpdateMyLocationRequest
     */
    public function setAccuracy($accuracy = null)
    {
        // validation for constraint: int
        if (!is_null($accuracy) && !is_numeric($accuracy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accuracy)), __LINE__);
        }
        $this->accuracy = $accuracy;
        return $this;
    }
    /**
     * Get altitudeAccuracy value
     * @return int|null
     */
    public function getAltitudeAccuracy()
    {
        return $this->altitudeAccuracy;
    }
    /**
     * Set altitudeAccuracy value
     * @param int $altitudeAccuracy
     * @return \QCC\CampusM\CloudService\StructType\UpdateMyLocationRequest
     */
    public function setAltitudeAccuracy($altitudeAccuracy = null)
    {
        // validation for constraint: int
        if (!is_null($altitudeAccuracy) && !is_numeric($altitudeAccuracy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($altitudeAccuracy)), __LINE__);
        }
        $this->altitudeAccuracy = $altitudeAccuracy;
        return $this;
    }
    /**
     * Get heading value
     * @return string|null
     */
    public function getHeading()
    {
        return $this->heading;
    }
    /**
     * Set heading value
     * @param string $heading
     * @return \QCC\CampusM\CloudService\StructType\UpdateMyLocationRequest
     */
    public function setHeading($heading = null)
    {
        // validation for constraint: string
        if (!is_null($heading) && !is_string($heading)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($heading)), __LINE__);
        }
        $this->heading = $heading;
        return $this;
    }
    /**
     * Get speed value
     * @return int|null
     */
    public function getSpeed()
    {
        return $this->speed;
    }
    /**
     * Set speed value
     * @param int $speed
     * @return \QCC\CampusM\CloudService\StructType\UpdateMyLocationRequest
     */
    public function setSpeed($speed = null)
    {
        // validation for constraint: int
        if (!is_null($speed) && !is_numeric($speed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($speed)), __LINE__);
        }
        $this->speed = $speed;
        return $this;
    }
    /**
     * Get lastComment value
     * @return string|null
     */
    public function getLastComment()
    {
        return $this->lastComment;
    }
    /**
     * Set lastComment value
     * @param string $lastComment
     * @return \QCC\CampusM\CloudService\StructType\UpdateMyLocationRequest
     */
    public function setLastComment($lastComment = null)
    {
        // validation for constraint: string
        if (!is_null($lastComment) && !is_string($lastComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastComment)), __LINE__);
        }
        $this->lastComment = $lastComment;
        return $this;
    }
    /**
     * Get lastImage value
     * @return string|null
     */
    public function getLastImage()
    {
        return $this->lastImage;
    }
    /**
     * Set lastImage value
     * @param string $lastImage
     * @return \QCC\CampusM\CloudService\StructType\UpdateMyLocationRequest
     */
    public function setLastImage($lastImage = null)
    {
        // validation for constraint: string
        if (!is_null($lastImage) && !is_string($lastImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastImage)), __LINE__);
        }
        $this->lastImage = $lastImage;
        return $this;
    }
    /**
     * Get checkInLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCheckInLocation()
    {
        return isset($this->checkInLocation) ? $this->checkInLocation : null;
    }
    /**
     * Set checkInLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $checkInLocation
     * @return \QCC\CampusM\CloudService\StructType\UpdateMyLocationRequest
     */
    public function setCheckInLocation($checkInLocation = null)
    {
        // validation for constraint: string
        if (!is_null($checkInLocation) && !is_string($checkInLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkInLocation)), __LINE__);
        }
        if (is_null($checkInLocation) || (is_array($checkInLocation) && empty($checkInLocation))) {
            unset($this->checkInLocation);
        } else {
            $this->checkInLocation = $checkInLocation;
        }
        return $this;
    }
    /**
     * Get checkInPositionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCheckInPositionId()
    {
        return isset($this->checkInPositionId) ? $this->checkInPositionId : null;
    }
    /**
     * Set checkInPositionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $checkInPositionId
     * @return \QCC\CampusM\CloudService\StructType\UpdateMyLocationRequest
     */
    public function setCheckInPositionId($checkInPositionId = null)
    {
        // validation for constraint: int
        if (!is_null($checkInPositionId) && !is_numeric($checkInPositionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($checkInPositionId)), __LINE__);
        }
        if (is_null($checkInPositionId) || (is_array($checkInPositionId) && empty($checkInPositionId))) {
            unset($this->checkInPositionId);
        } else {
            $this->checkInPositionId = $checkInPositionId;
        }
        return $this;
    }
    /**
     * Get checkInFavourite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCheckInFavourite()
    {
        return isset($this->checkInFavourite) ? $this->checkInFavourite : null;
    }
    /**
     * Set checkInFavourite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $checkInFavourite
     * @return \QCC\CampusM\CloudService\StructType\UpdateMyLocationRequest
     */
    public function setCheckInFavourite($checkInFavourite = null)
    {
        // validation for constraint: string
        if (!is_null($checkInFavourite) && !is_string($checkInFavourite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkInFavourite)), __LINE__);
        }
        if (is_null($checkInFavourite) || (is_array($checkInFavourite) && empty($checkInFavourite))) {
            unset($this->checkInFavourite);
        } else {
            $this->checkInFavourite = $checkInFavourite;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\UpdateMyLocationRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
