<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateFriendsRequest StructType
 * @subpackage Structs
 */
class UpdateFriendsRequest extends AbstractStructBase
{
    /**
     * The personId
     * @var int
     */
    public $personId;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The ufriends
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\Ufriends
     */
    public $ufriends;
    /**
     * Constructor method for updateFriendsRequest
     * @uses UpdateFriendsRequest::setPersonId()
     * @uses UpdateFriendsRequest::setPassword()
     * @uses UpdateFriendsRequest::setUfriends()
     * @param int $personId
     * @param string $password
     * @param \QCC\CampusM\CloudService\StructType\Ufriends $ufriends
     */
    public function __construct($personId = null, $password = null, \QCC\CampusM\CloudService\StructType\Ufriends $ufriends = null)
    {
        $this
            ->setPersonId($personId)
            ->setPassword($password)
            ->setUfriends($ufriends);
    }
    /**
     * Get personId value
     * @return int|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param int $personId
     * @return \QCC\CampusM\CloudService\StructType\UpdateFriendsRequest
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: int
        if (!is_null($personId) && !is_numeric($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \QCC\CampusM\CloudService\StructType\UpdateFriendsRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get ufriends value
     * @return \QCC\CampusM\CloudService\StructType\Ufriends|null
     */
    public function getUfriends()
    {
        return $this->ufriends;
    }
    /**
     * Set ufriends value
     * @param \QCC\CampusM\CloudService\StructType\Ufriends $ufriends
     * @return \QCC\CampusM\CloudService\StructType\UpdateFriendsRequest
     */
    public function setUfriends(\QCC\CampusM\CloudService\StructType\Ufriends $ufriends = null)
    {
        $this->ufriends = $ufriends;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\UpdateFriendsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
