<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for typesOfWork StructType
 * @subpackage Structs
 */
class TypesOfWork extends AbstractStructBase
{
    /**
     * The tow
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $tow;
    /**
     * Constructor method for typesOfWork
     * @uses TypesOfWork::setTow()
     * @param string[] $tow
     */
    public function __construct(array $tow = array())
    {
        $this
            ->setTow($tow);
    }
    /**
     * Get tow value
     * @return string[]|null
     */
    public function getTow()
    {
        return $this->tow;
    }
    /**
     * Set tow value
     * @throws \InvalidArgumentException
     * @param string[] $tow
     * @return \QCC\CampusM\CloudService\StructType\TypesOfWork
     */
    public function setTow(array $tow = array())
    {
        foreach ($tow as $typesOfWorkTowItem) {
            // validation for constraint: itemType
            if (!is_string($typesOfWorkTowItem)) {
                throw new \InvalidArgumentException(sprintf('The tow property can only contain items of string, "%s" given', is_object($typesOfWorkTowItem) ? get_class($typesOfWorkTowItem) : gettype($typesOfWorkTowItem)), __LINE__);
            }
        }
        $this->tow = $tow;
        return $this;
    }
    /**
     * Add item to tow value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \QCC\CampusM\CloudService\StructType\TypesOfWork
     */
    public function addToTow($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The tow property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->tow[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\TypesOfWork
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
