<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for suggestions StructType
 * @subpackage Structs
 */
class Suggestions extends AbstractStructBase
{
    /**
     * The suggestion
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $suggestion;
    /**
     * Constructor method for suggestions
     * @uses Suggestions::setSuggestion()
     * @param string[] $suggestion
     */
    public function __construct(array $suggestion = array())
    {
        $this
            ->setSuggestion($suggestion);
    }
    /**
     * Get suggestion value
     * @return string[]|null
     */
    public function getSuggestion()
    {
        return $this->suggestion;
    }
    /**
     * Set suggestion value
     * @throws \InvalidArgumentException
     * @param string[] $suggestion
     * @return \QCC\CampusM\CloudService\StructType\Suggestions
     */
    public function setSuggestion(array $suggestion = array())
    {
        foreach ($suggestion as $suggestionsSuggestionItem) {
            // validation for constraint: itemType
            if (!is_string($suggestionsSuggestionItem)) {
                throw new \InvalidArgumentException(sprintf('The suggestion property can only contain items of string, "%s" given', is_object($suggestionsSuggestionItem) ? get_class($suggestionsSuggestionItem) : gettype($suggestionsSuggestionItem)), __LINE__);
            }
        }
        $this->suggestion = $suggestion;
        return $this;
    }
    /**
     * Add item to suggestion value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \QCC\CampusM\CloudService\StructType\Suggestions
     */
    public function addToSuggestion($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The suggestion property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->suggestion[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\Suggestions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
