<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for submitUserFeedback StructType
 * @subpackage Structs
 */
class SubmitUserFeedback extends UserFeedbackSupertype
{
    /**
     * The appOrPage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $appOrPage;
    /**
     * The pageTitle
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pageTitle;
    /**
     * The comments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $comments;
    /**
     * The rating
     * Meta informations extracted from the WSDL
     * - maxInclusive: 5
     * - minInclusive: 1
     * @var int
     */
    public $rating;
    /**
     * Constructor method for submitUserFeedback
     * @uses SubmitUserFeedback::setAppOrPage()
     * @uses SubmitUserFeedback::setPageTitle()
     * @uses SubmitUserFeedback::setComments()
     * @uses SubmitUserFeedback::setRating()
     * @param string $appOrPage
     * @param string $pageTitle
     * @param string $comments
     * @param int $rating
     */
    public function __construct($appOrPage = null, $pageTitle = null, $comments = null, $rating = null)
    {
        $this
            ->setAppOrPage($appOrPage)
            ->setPageTitle($pageTitle)
            ->setComments($comments)
            ->setRating($rating);
    }
    /**
     * Get appOrPage value
     * @return string|null
     */
    public function getAppOrPage()
    {
        return $this->appOrPage;
    }
    /**
     * Set appOrPage value
     * @uses \QCC\CampusM\CloudService\EnumType\AppOrPage::valueIsValid()
     * @uses \QCC\CampusM\CloudService\EnumType\AppOrPage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $appOrPage
     * @return \QCC\CampusM\CloudService\StructType\SubmitUserFeedback
     */
    public function setAppOrPage($appOrPage = null)
    {
        // validation for constraint: enumeration
        if (!\QCC\CampusM\CloudService\EnumType\AppOrPage::valueIsValid($appOrPage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $appOrPage, implode(', ', \QCC\CampusM\CloudService\EnumType\AppOrPage::getValidValues())), __LINE__);
        }
        $this->appOrPage = $appOrPage;
        return $this;
    }
    /**
     * Get pageTitle value
     * @return string|null
     */
    public function getPageTitle()
    {
        return $this->pageTitle;
    }
    /**
     * Set pageTitle value
     * @param string $pageTitle
     * @return \QCC\CampusM\CloudService\StructType\SubmitUserFeedback
     */
    public function setPageTitle($pageTitle = null)
    {
        // validation for constraint: string
        if (!is_null($pageTitle) && !is_string($pageTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pageTitle)), __LINE__);
        }
        $this->pageTitle = $pageTitle;
        return $this;
    }
    /**
     * Get comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->comments;
    }
    /**
     * Set comments value
     * @param string $comments
     * @return \QCC\CampusM\CloudService\StructType\SubmitUserFeedback
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comments)), __LINE__);
        }
        $this->comments = $comments;
        return $this;
    }
    /**
     * Get rating value
     * @return int|null
     */
    public function getRating()
    {
        return $this->rating;
    }
    /**
     * Set rating value
     * @param int $rating
     * @return \QCC\CampusM\CloudService\StructType\SubmitUserFeedback
     */
    public function setRating($rating = null)
    {
        // validation for constraint: maxInclusive
        if ($rating > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 5, "%s" given', $rating), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($rating < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $rating), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($rating) && !is_numeric($rating)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rating)), __LINE__);
        }
        $this->rating = $rating;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\SubmitUserFeedback
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
