<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for startupFlow StructType
 * @subpackage Structs
 */
class StartupFlow extends AbstractStructBase
{
    /**
     * The startupFlowId
     * @var int
     */
    public $startupFlowId;
    /**
     * The nativeComponent
     * @var string
     */
    public $nativeComponent;
    /**
     * The sortOrder
     * @var int
     */
    public $sortOrder;
    /**
     * The stepDescription
     * @var string
     */
    public $stepDescription;
    /**
     * The stepPrompt
     * @var string
     */
    public $stepPrompt;
    /**
     * The menuDescription
     * @var string
     */
    public $menuDescription;
    /**
     * The useOnStartup
     * @var string
     */
    public $useOnStartup;
    /**
     * The flowStrings
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\FlowStrings
     */
    public $flowStrings;
    /**
     * The flowServices
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\FlowServices
     */
    public $flowServices;
    /**
     * Constructor method for startupFlow
     * @uses StartupFlow::setStartupFlowId()
     * @uses StartupFlow::setNativeComponent()
     * @uses StartupFlow::setSortOrder()
     * @uses StartupFlow::setStepDescription()
     * @uses StartupFlow::setStepPrompt()
     * @uses StartupFlow::setMenuDescription()
     * @uses StartupFlow::setUseOnStartup()
     * @uses StartupFlow::setFlowStrings()
     * @uses StartupFlow::setFlowServices()
     * @param int $startupFlowId
     * @param string $nativeComponent
     * @param int $sortOrder
     * @param string $stepDescription
     * @param string $stepPrompt
     * @param string $menuDescription
     * @param string $useOnStartup
     * @param \QCC\CampusM\CloudService\StructType\FlowStrings $flowStrings
     * @param \QCC\CampusM\CloudService\StructType\FlowServices $flowServices
     */
    public function __construct($startupFlowId = null, $nativeComponent = null, $sortOrder = null, $stepDescription = null, $stepPrompt = null, $menuDescription = null, $useOnStartup = null, \QCC\CampusM\CloudService\StructType\FlowStrings $flowStrings = null, \QCC\CampusM\CloudService\StructType\FlowServices $flowServices = null)
    {
        $this
            ->setStartupFlowId($startupFlowId)
            ->setNativeComponent($nativeComponent)
            ->setSortOrder($sortOrder)
            ->setStepDescription($stepDescription)
            ->setStepPrompt($stepPrompt)
            ->setMenuDescription($menuDescription)
            ->setUseOnStartup($useOnStartup)
            ->setFlowStrings($flowStrings)
            ->setFlowServices($flowServices);
    }
    /**
     * Get startupFlowId value
     * @return int|null
     */
    public function getStartupFlowId()
    {
        return $this->startupFlowId;
    }
    /**
     * Set startupFlowId value
     * @param int $startupFlowId
     * @return \QCC\CampusM\CloudService\StructType\StartupFlow
     */
    public function setStartupFlowId($startupFlowId = null)
    {
        // validation for constraint: int
        if (!is_null($startupFlowId) && !is_numeric($startupFlowId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($startupFlowId)), __LINE__);
        }
        $this->startupFlowId = $startupFlowId;
        return $this;
    }
    /**
     * Get nativeComponent value
     * @return string|null
     */
    public function getNativeComponent()
    {
        return $this->nativeComponent;
    }
    /**
     * Set nativeComponent value
     * @param string $nativeComponent
     * @return \QCC\CampusM\CloudService\StructType\StartupFlow
     */
    public function setNativeComponent($nativeComponent = null)
    {
        // validation for constraint: string
        if (!is_null($nativeComponent) && !is_string($nativeComponent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nativeComponent)), __LINE__);
        }
        $this->nativeComponent = $nativeComponent;
        return $this;
    }
    /**
     * Get sortOrder value
     * @return int|null
     */
    public function getSortOrder()
    {
        return $this->sortOrder;
    }
    /**
     * Set sortOrder value
     * @param int $sortOrder
     * @return \QCC\CampusM\CloudService\StructType\StartupFlow
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: int
        if (!is_null($sortOrder) && !is_numeric($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sortOrder)), __LINE__);
        }
        $this->sortOrder = $sortOrder;
        return $this;
    }
    /**
     * Get stepDescription value
     * @return string|null
     */
    public function getStepDescription()
    {
        return $this->stepDescription;
    }
    /**
     * Set stepDescription value
     * @param string $stepDescription
     * @return \QCC\CampusM\CloudService\StructType\StartupFlow
     */
    public function setStepDescription($stepDescription = null)
    {
        // validation for constraint: string
        if (!is_null($stepDescription) && !is_string($stepDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stepDescription)), __LINE__);
        }
        $this->stepDescription = $stepDescription;
        return $this;
    }
    /**
     * Get stepPrompt value
     * @return string|null
     */
    public function getStepPrompt()
    {
        return $this->stepPrompt;
    }
    /**
     * Set stepPrompt value
     * @param string $stepPrompt
     * @return \QCC\CampusM\CloudService\StructType\StartupFlow
     */
    public function setStepPrompt($stepPrompt = null)
    {
        // validation for constraint: string
        if (!is_null($stepPrompt) && !is_string($stepPrompt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stepPrompt)), __LINE__);
        }
        $this->stepPrompt = $stepPrompt;
        return $this;
    }
    /**
     * Get menuDescription value
     * @return string|null
     */
    public function getMenuDescription()
    {
        return $this->menuDescription;
    }
    /**
     * Set menuDescription value
     * @param string $menuDescription
     * @return \QCC\CampusM\CloudService\StructType\StartupFlow
     */
    public function setMenuDescription($menuDescription = null)
    {
        // validation for constraint: string
        if (!is_null($menuDescription) && !is_string($menuDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($menuDescription)), __LINE__);
        }
        $this->menuDescription = $menuDescription;
        return $this;
    }
    /**
     * Get useOnStartup value
     * @return string|null
     */
    public function getUseOnStartup()
    {
        return $this->useOnStartup;
    }
    /**
     * Set useOnStartup value
     * @param string $useOnStartup
     * @return \QCC\CampusM\CloudService\StructType\StartupFlow
     */
    public function setUseOnStartup($useOnStartup = null)
    {
        // validation for constraint: string
        if (!is_null($useOnStartup) && !is_string($useOnStartup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useOnStartup)), __LINE__);
        }
        $this->useOnStartup = $useOnStartup;
        return $this;
    }
    /**
     * Get flowStrings value
     * @return \QCC\CampusM\CloudService\StructType\FlowStrings|null
     */
    public function getFlowStrings()
    {
        return $this->flowStrings;
    }
    /**
     * Set flowStrings value
     * @param \QCC\CampusM\CloudService\StructType\FlowStrings $flowStrings
     * @return \QCC\CampusM\CloudService\StructType\StartupFlow
     */
    public function setFlowStrings(\QCC\CampusM\CloudService\StructType\FlowStrings $flowStrings = null)
    {
        $this->flowStrings = $flowStrings;
        return $this;
    }
    /**
     * Get flowServices value
     * @return \QCC\CampusM\CloudService\StructType\FlowServices|null
     */
    public function getFlowServices()
    {
        return $this->flowServices;
    }
    /**
     * Set flowServices value
     * @param \QCC\CampusM\CloudService\StructType\FlowServices $flowServices
     * @return \QCC\CampusM\CloudService\StructType\StartupFlow
     */
    public function setFlowServices(\QCC\CampusM\CloudService\StructType\FlowServices $flowServices = null)
    {
        $this->flowServices = $flowServices;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\StartupFlow
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
