<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sendIntegratedAlertsRequest StructType
 * @subpackage Structs
 */
class SendIntegratedAlertsRequest extends AbstractStructBase
{
    /**
     * The orgCode
     * @var int
     */
    public $orgCode;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The alertGroupId
     * @var string
     */
    public $alertGroupId;
    /**
     * The serviceType
     * @var string
     */
    public $serviceType;
    /**
     * The reminderExpiry
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $reminderExpiry;
    /**
     * The reminderInterval
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $reminderInterval;
    /**
     * The authGroups
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\AuthGroups
     */
    public $authGroups;
    /**
     * Constructor method for sendIntegratedAlertsRequest
     * @uses SendIntegratedAlertsRequest::setOrgCode()
     * @uses SendIntegratedAlertsRequest::setPassword()
     * @uses SendIntegratedAlertsRequest::setAlertGroupId()
     * @uses SendIntegratedAlertsRequest::setServiceType()
     * @uses SendIntegratedAlertsRequest::setReminderExpiry()
     * @uses SendIntegratedAlertsRequest::setReminderInterval()
     * @uses SendIntegratedAlertsRequest::setAuthGroups()
     * @param int $orgCode
     * @param string $password
     * @param string $alertGroupId
     * @param string $serviceType
     * @param int $reminderExpiry
     * @param int $reminderInterval
     * @param \QCC\CampusM\CloudService\StructType\AuthGroups $authGroups
     */
    public function __construct($orgCode = null, $password = null, $alertGroupId = null, $serviceType = null, $reminderExpiry = null, $reminderInterval = null, \QCC\CampusM\CloudService\StructType\AuthGroups $authGroups = null)
    {
        $this
            ->setOrgCode($orgCode)
            ->setPassword($password)
            ->setAlertGroupId($alertGroupId)
            ->setServiceType($serviceType)
            ->setReminderExpiry($reminderExpiry)
            ->setReminderInterval($reminderInterval)
            ->setAuthGroups($authGroups);
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\SendIntegratedAlertsRequest
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \QCC\CampusM\CloudService\StructType\SendIntegratedAlertsRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get alertGroupId value
     * @return string|null
     */
    public function getAlertGroupId()
    {
        return $this->alertGroupId;
    }
    /**
     * Set alertGroupId value
     * @param string $alertGroupId
     * @return \QCC\CampusM\CloudService\StructType\SendIntegratedAlertsRequest
     */
    public function setAlertGroupId($alertGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($alertGroupId) && !is_string($alertGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alertGroupId)), __LINE__);
        }
        $this->alertGroupId = $alertGroupId;
        return $this;
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @param string $serviceType
     * @return \QCC\CampusM\CloudService\StructType\SendIntegratedAlertsRequest
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: string
        if (!is_null($serviceType) && !is_string($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceType)), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get reminderExpiry value
     * @return int|null
     */
    public function getReminderExpiry()
    {
        return $this->reminderExpiry;
    }
    /**
     * Set reminderExpiry value
     * @param int $reminderExpiry
     * @return \QCC\CampusM\CloudService\StructType\SendIntegratedAlertsRequest
     */
    public function setReminderExpiry($reminderExpiry = null)
    {
        // validation for constraint: int
        if (!is_null($reminderExpiry) && !is_numeric($reminderExpiry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reminderExpiry)), __LINE__);
        }
        $this->reminderExpiry = $reminderExpiry;
        return $this;
    }
    /**
     * Get reminderInterval value
     * @return int|null
     */
    public function getReminderInterval()
    {
        return $this->reminderInterval;
    }
    /**
     * Set reminderInterval value
     * @param int $reminderInterval
     * @return \QCC\CampusM\CloudService\StructType\SendIntegratedAlertsRequest
     */
    public function setReminderInterval($reminderInterval = null)
    {
        // validation for constraint: int
        if (!is_null($reminderInterval) && !is_numeric($reminderInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reminderInterval)), __LINE__);
        }
        $this->reminderInterval = $reminderInterval;
        return $this;
    }
    /**
     * Get authGroups value
     * @return \QCC\CampusM\CloudService\StructType\AuthGroups|null
     */
    public function getAuthGroups()
    {
        return $this->authGroups;
    }
    /**
     * Set authGroups value
     * @param \QCC\CampusM\CloudService\StructType\AuthGroups $authGroups
     * @return \QCC\CampusM\CloudService\StructType\SendIntegratedAlertsRequest
     */
    public function setAuthGroups(\QCC\CampusM\CloudService\StructType\AuthGroups $authGroups = null)
    {
        $this->authGroups = $authGroups;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\SendIntegratedAlertsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
