<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for reportItEntry StructType
 * @subpackage Structs
 */
class ReportItEntry extends AbstractStructBase
{
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The image
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $image;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The link
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $link;
    /**
     * The feedback_alerts
     * @var string
     */
    public $feedback_alerts;
    /**
     * The sort_order
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sort_order;
    /**
     * The reportItEntryOptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\ReportItEntryOptions
     */
    public $reportItEntryOptions;
    /**
     * The reportItEntryPersonalDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\ReportItEntryPersonalDetails
     */
    public $reportItEntryPersonalDetails;
    /**
     * Constructor method for reportItEntry
     * @uses ReportItEntry::setDescription()
     * @uses ReportItEntry::setImage()
     * @uses ReportItEntry::setType()
     * @uses ReportItEntry::setLink()
     * @uses ReportItEntry::setFeedback_alerts()
     * @uses ReportItEntry::setSort_order()
     * @uses ReportItEntry::setReportItEntryOptions()
     * @uses ReportItEntry::setReportItEntryPersonalDetails()
     * @param string $description
     * @param string $image
     * @param string $type
     * @param string $link
     * @param string $feedback_alerts
     * @param int $sort_order
     * @param \QCC\CampusM\CloudService\StructType\ReportItEntryOptions $reportItEntryOptions
     * @param \QCC\CampusM\CloudService\StructType\ReportItEntryPersonalDetails $reportItEntryPersonalDetails
     */
    public function __construct($description = null, $image = null, $type = null, $link = null, $feedback_alerts = null, $sort_order = null, \QCC\CampusM\CloudService\StructType\ReportItEntryOptions $reportItEntryOptions = null, \QCC\CampusM\CloudService\StructType\ReportItEntryPersonalDetails $reportItEntryPersonalDetails = null)
    {
        $this
            ->setDescription($description)
            ->setImage($image)
            ->setType($type)
            ->setLink($link)
            ->setFeedback_alerts($feedback_alerts)
            ->setSort_order($sort_order)
            ->setReportItEntryOptions($reportItEntryOptions)
            ->setReportItEntryPersonalDetails($reportItEntryPersonalDetails);
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \QCC\CampusM\CloudService\StructType\ReportItEntry
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get image value
     * @return string|null
     */
    public function getImage()
    {
        return $this->image;
    }
    /**
     * Set image value
     * @param string $image
     * @return \QCC\CampusM\CloudService\StructType\ReportItEntry
     */
    public function setImage($image = null)
    {
        // validation for constraint: string
        if (!is_null($image) && !is_string($image)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($image)), __LINE__);
        }
        $this->image = $image;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \QCC\CampusM\CloudService\StructType\ReportItEntry
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get link value
     * @return string|null
     */
    public function getLink()
    {
        return $this->link;
    }
    /**
     * Set link value
     * @param string $link
     * @return \QCC\CampusM\CloudService\StructType\ReportItEntry
     */
    public function setLink($link = null)
    {
        // validation for constraint: string
        if (!is_null($link) && !is_string($link)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($link)), __LINE__);
        }
        $this->link = $link;
        return $this;
    }
    /**
     * Get feedback_alerts value
     * @return string|null
     */
    public function getFeedback_alerts()
    {
        return $this->feedback_alerts;
    }
    /**
     * Set feedback_alerts value
     * @param string $feedback_alerts
     * @return \QCC\CampusM\CloudService\StructType\ReportItEntry
     */
    public function setFeedback_alerts($feedback_alerts = null)
    {
        // validation for constraint: string
        if (!is_null($feedback_alerts) && !is_string($feedback_alerts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($feedback_alerts)), __LINE__);
        }
        $this->feedback_alerts = $feedback_alerts;
        return $this;
    }
    /**
     * Get sort_order value
     * @return int|null
     */
    public function getSort_order()
    {
        return $this->sort_order;
    }
    /**
     * Set sort_order value
     * @param int $sort_order
     * @return \QCC\CampusM\CloudService\StructType\ReportItEntry
     */
    public function setSort_order($sort_order = null)
    {
        // validation for constraint: int
        if (!is_null($sort_order) && !is_numeric($sort_order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sort_order)), __LINE__);
        }
        $this->sort_order = $sort_order;
        return $this;
    }
    /**
     * Get reportItEntryOptions value
     * @return \QCC\CampusM\CloudService\StructType\ReportItEntryOptions|null
     */
    public function getReportItEntryOptions()
    {
        return $this->reportItEntryOptions;
    }
    /**
     * Set reportItEntryOptions value
     * @param \QCC\CampusM\CloudService\StructType\ReportItEntryOptions $reportItEntryOptions
     * @return \QCC\CampusM\CloudService\StructType\ReportItEntry
     */
    public function setReportItEntryOptions(\QCC\CampusM\CloudService\StructType\ReportItEntryOptions $reportItEntryOptions = null)
    {
        $this->reportItEntryOptions = $reportItEntryOptions;
        return $this;
    }
    /**
     * Get reportItEntryPersonalDetails value
     * @return \QCC\CampusM\CloudService\StructType\ReportItEntryPersonalDetails|null
     */
    public function getReportItEntryPersonalDetails()
    {
        return $this->reportItEntryPersonalDetails;
    }
    /**
     * Set reportItEntryPersonalDetails value
     * @param \QCC\CampusM\CloudService\StructType\ReportItEntryPersonalDetails $reportItEntryPersonalDetails
     * @return \QCC\CampusM\CloudService\StructType\ReportItEntry
     */
    public function setReportItEntryPersonalDetails(\QCC\CampusM\CloudService\StructType\ReportItEntryPersonalDetails $reportItEntryPersonalDetails = null)
    {
        $this->reportItEntryPersonalDetails = $reportItEntryPersonalDetails;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\ReportItEntry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
