<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for reportItCategory StructType
 * @subpackage Structs
 */
class ReportItCategory extends AbstractStructBase
{
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The image
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $image;
    /**
     * The sort_order
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sort_order;
    /**
     * The reportItEntries
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\ReportItEntries
     */
    public $reportItEntries;
    /**
     * Constructor method for reportItCategory
     * @uses ReportItCategory::setDescription()
     * @uses ReportItCategory::setImage()
     * @uses ReportItCategory::setSort_order()
     * @uses ReportItCategory::setReportItEntries()
     * @param string $description
     * @param string $image
     * @param int $sort_order
     * @param \QCC\CampusM\CloudService\StructType\ReportItEntries $reportItEntries
     */
    public function __construct($description = null, $image = null, $sort_order = null, \QCC\CampusM\CloudService\StructType\ReportItEntries $reportItEntries = null)
    {
        $this
            ->setDescription($description)
            ->setImage($image)
            ->setSort_order($sort_order)
            ->setReportItEntries($reportItEntries);
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \QCC\CampusM\CloudService\StructType\ReportItCategory
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get image value
     * @return string|null
     */
    public function getImage()
    {
        return $this->image;
    }
    /**
     * Set image value
     * @param string $image
     * @return \QCC\CampusM\CloudService\StructType\ReportItCategory
     */
    public function setImage($image = null)
    {
        // validation for constraint: string
        if (!is_null($image) && !is_string($image)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($image)), __LINE__);
        }
        $this->image = $image;
        return $this;
    }
    /**
     * Get sort_order value
     * @return int|null
     */
    public function getSort_order()
    {
        return $this->sort_order;
    }
    /**
     * Set sort_order value
     * @param int $sort_order
     * @return \QCC\CampusM\CloudService\StructType\ReportItCategory
     */
    public function setSort_order($sort_order = null)
    {
        // validation for constraint: int
        if (!is_null($sort_order) && !is_numeric($sort_order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sort_order)), __LINE__);
        }
        $this->sort_order = $sort_order;
        return $this;
    }
    /**
     * Get reportItEntries value
     * @return \QCC\CampusM\CloudService\StructType\ReportItEntries|null
     */
    public function getReportItEntries()
    {
        return $this->reportItEntries;
    }
    /**
     * Set reportItEntries value
     * @param \QCC\CampusM\CloudService\StructType\ReportItEntries $reportItEntries
     * @return \QCC\CampusM\CloudService\StructType\ReportItCategory
     */
    public function setReportItEntries(\QCC\CampusM\CloudService\StructType\ReportItEntries $reportItEntries = null)
    {
        $this->reportItEntries = $reportItEntries;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\ReportItCategory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
