<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for profile StructType
 * @subpackage Structs
 */
class Profile extends AbstractStructBase
{
    /**
     * The profileId
     * @var int
     */
    public $profileId;
    /**
     * The languagePackId
     * @var int
     */
    public $languagePackId;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The information
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $information;
    /**
     * The splashImage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $splashImage;
    /**
     * The pocketGuideUpdated
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pocketGuideUpdated;
    /**
     * The sortOrder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sortOrder;
    /**
     * The matchingRoles
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\RoleNames
     */
    public $matchingRoles;
    /**
     * The tutorialRootPGCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $tutorialRootPGCode;
    /**
     * The runFlowsOnStartup
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $runFlowsOnStartup;
    /**
     * The startupFlows
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\StartupFlows
     */
    public $startupFlows;
    /**
     * Constructor method for profile
     * @uses Profile::setProfileId()
     * @uses Profile::setLanguagePackId()
     * @uses Profile::setDescription()
     * @uses Profile::setInformation()
     * @uses Profile::setSplashImage()
     * @uses Profile::setPocketGuideUpdated()
     * @uses Profile::setSortOrder()
     * @uses Profile::setMatchingRoles()
     * @uses Profile::setTutorialRootPGCode()
     * @uses Profile::setRunFlowsOnStartup()
     * @uses Profile::setStartupFlows()
     * @param int $profileId
     * @param int $languagePackId
     * @param string $description
     * @param string $information
     * @param string $splashImage
     * @param string $pocketGuideUpdated
     * @param int $sortOrder
     * @param \QCC\CampusM\CloudService\StructType\RoleNames $matchingRoles
     * @param int $tutorialRootPGCode
     * @param string $runFlowsOnStartup
     * @param \QCC\CampusM\CloudService\StructType\StartupFlows $startupFlows
     */
    public function __construct($profileId = null, $languagePackId = null, $description = null, $information = null, $splashImage = null, $pocketGuideUpdated = null, $sortOrder = null, \QCC\CampusM\CloudService\StructType\RoleNames $matchingRoles = null, $tutorialRootPGCode = null, $runFlowsOnStartup = null, \QCC\CampusM\CloudService\StructType\StartupFlows $startupFlows = null)
    {
        $this
            ->setProfileId($profileId)
            ->setLanguagePackId($languagePackId)
            ->setDescription($description)
            ->setInformation($information)
            ->setSplashImage($splashImage)
            ->setPocketGuideUpdated($pocketGuideUpdated)
            ->setSortOrder($sortOrder)
            ->setMatchingRoles($matchingRoles)
            ->setTutorialRootPGCode($tutorialRootPGCode)
            ->setRunFlowsOnStartup($runFlowsOnStartup)
            ->setStartupFlows($startupFlows);
    }
    /**
     * Get profileId value
     * @return int|null
     */
    public function getProfileId()
    {
        return $this->profileId;
    }
    /**
     * Set profileId value
     * @param int $profileId
     * @return \QCC\CampusM\CloudService\StructType\Profile
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !is_numeric($profileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($profileId)), __LINE__);
        }
        $this->profileId = $profileId;
        return $this;
    }
    /**
     * Get languagePackId value
     * @return int|null
     */
    public function getLanguagePackId()
    {
        return $this->languagePackId;
    }
    /**
     * Set languagePackId value
     * @param int $languagePackId
     * @return \QCC\CampusM\CloudService\StructType\Profile
     */
    public function setLanguagePackId($languagePackId = null)
    {
        // validation for constraint: int
        if (!is_null($languagePackId) && !is_numeric($languagePackId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($languagePackId)), __LINE__);
        }
        $this->languagePackId = $languagePackId;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \QCC\CampusM\CloudService\StructType\Profile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get information value
     * @return string|null
     */
    public function getInformation()
    {
        return $this->information;
    }
    /**
     * Set information value
     * @param string $information
     * @return \QCC\CampusM\CloudService\StructType\Profile
     */
    public function setInformation($information = null)
    {
        // validation for constraint: string
        if (!is_null($information) && !is_string($information)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($information)), __LINE__);
        }
        $this->information = $information;
        return $this;
    }
    /**
     * Get splashImage value
     * @return string|null
     */
    public function getSplashImage()
    {
        return $this->splashImage;
    }
    /**
     * Set splashImage value
     * @param string $splashImage
     * @return \QCC\CampusM\CloudService\StructType\Profile
     */
    public function setSplashImage($splashImage = null)
    {
        // validation for constraint: string
        if (!is_null($splashImage) && !is_string($splashImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($splashImage)), __LINE__);
        }
        $this->splashImage = $splashImage;
        return $this;
    }
    /**
     * Get pocketGuideUpdated value
     * @return string|null
     */
    public function getPocketGuideUpdated()
    {
        return $this->pocketGuideUpdated;
    }
    /**
     * Set pocketGuideUpdated value
     * @param string $pocketGuideUpdated
     * @return \QCC\CampusM\CloudService\StructType\Profile
     */
    public function setPocketGuideUpdated($pocketGuideUpdated = null)
    {
        // validation for constraint: string
        if (!is_null($pocketGuideUpdated) && !is_string($pocketGuideUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pocketGuideUpdated)), __LINE__);
        }
        $this->pocketGuideUpdated = $pocketGuideUpdated;
        return $this;
    }
    /**
     * Get sortOrder value
     * @return int|null
     */
    public function getSortOrder()
    {
        return $this->sortOrder;
    }
    /**
     * Set sortOrder value
     * @param int $sortOrder
     * @return \QCC\CampusM\CloudService\StructType\Profile
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: int
        if (!is_null($sortOrder) && !is_numeric($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sortOrder)), __LINE__);
        }
        $this->sortOrder = $sortOrder;
        return $this;
    }
    /**
     * Get matchingRoles value
     * @return \QCC\CampusM\CloudService\StructType\RoleNames|null
     */
    public function getMatchingRoles()
    {
        return $this->matchingRoles;
    }
    /**
     * Set matchingRoles value
     * @param \QCC\CampusM\CloudService\StructType\RoleNames $matchingRoles
     * @return \QCC\CampusM\CloudService\StructType\Profile
     */
    public function setMatchingRoles(\QCC\CampusM\CloudService\StructType\RoleNames $matchingRoles = null)
    {
        $this->matchingRoles = $matchingRoles;
        return $this;
    }
    /**
     * Get tutorialRootPGCode value
     * @return int|null
     */
    public function getTutorialRootPGCode()
    {
        return $this->tutorialRootPGCode;
    }
    /**
     * Set tutorialRootPGCode value
     * @param int $tutorialRootPGCode
     * @return \QCC\CampusM\CloudService\StructType\Profile
     */
    public function setTutorialRootPGCode($tutorialRootPGCode = null)
    {
        // validation for constraint: int
        if (!is_null($tutorialRootPGCode) && !is_numeric($tutorialRootPGCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tutorialRootPGCode)), __LINE__);
        }
        $this->tutorialRootPGCode = $tutorialRootPGCode;
        return $this;
    }
    /**
     * Get runFlowsOnStartup value
     * @return string|null
     */
    public function getRunFlowsOnStartup()
    {
        return $this->runFlowsOnStartup;
    }
    /**
     * Set runFlowsOnStartup value
     * @param string $runFlowsOnStartup
     * @return \QCC\CampusM\CloudService\StructType\Profile
     */
    public function setRunFlowsOnStartup($runFlowsOnStartup = null)
    {
        // validation for constraint: string
        if (!is_null($runFlowsOnStartup) && !is_string($runFlowsOnStartup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($runFlowsOnStartup)), __LINE__);
        }
        $this->runFlowsOnStartup = $runFlowsOnStartup;
        return $this;
    }
    /**
     * Get startupFlows value
     * @return \QCC\CampusM\CloudService\StructType\StartupFlows|null
     */
    public function getStartupFlows()
    {
        return $this->startupFlows;
    }
    /**
     * Set startupFlows value
     * @param \QCC\CampusM\CloudService\StructType\StartupFlows $startupFlows
     * @return \QCC\CampusM\CloudService\StructType\Profile
     */
    public function setStartupFlows(\QCC\CampusM\CloudService\StructType\StartupFlows $startupFlows = null)
    {
        $this->startupFlows = $startupFlows;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\Profile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
