<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for personVotes StructType
 * @subpackage Structs
 */
class PersonVotes extends AbstractStructBase
{
    /**
     * The personVote
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var int[]
     */
    public $personVote;
    /**
     * The freeText
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $freeText;
    /**
     * Constructor method for personVotes
     * @uses PersonVotes::setPersonVote()
     * @uses PersonVotes::setFreeText()
     * @param int[] $personVote
     * @param string $freeText
     */
    public function __construct(array $personVote = array(), $freeText = null)
    {
        $this
            ->setPersonVote($personVote)
            ->setFreeText($freeText);
    }
    /**
     * Get personVote value
     * @return int[]|null
     */
    public function getPersonVote()
    {
        return $this->personVote;
    }
    /**
     * Set personVote value
     * @throws \InvalidArgumentException
     * @param int[] $personVote
     * @return \QCC\CampusM\CloudService\StructType\PersonVotes
     */
    public function setPersonVote(array $personVote = array())
    {
        foreach ($personVote as $personVotesPersonVoteItem) {
            // validation for constraint: itemType
            if (!is_numeric($personVotesPersonVoteItem)) {
                throw new \InvalidArgumentException(sprintf('The personVote property can only contain items of int, "%s" given', is_object($personVotesPersonVoteItem) ? get_class($personVotesPersonVoteItem) : gettype($personVotesPersonVoteItem)), __LINE__);
            }
        }
        $this->personVote = $personVote;
        return $this;
    }
    /**
     * Add item to personVote value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \QCC\CampusM\CloudService\StructType\PersonVotes
     */
    public function addToPersonVote($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The personVote property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->personVote[] = $item;
        return $this;
    }
    /**
     * Get freeText value
     * @return string|null
     */
    public function getFreeText()
    {
        return $this->freeText;
    }
    /**
     * Set freeText value
     * @param string $freeText
     * @return \QCC\CampusM\CloudService\StructType\PersonVotes
     */
    public function setFreeText($freeText = null)
    {
        // validation for constraint: string
        if (!is_null($freeText) && !is_string($freeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($freeText)), __LINE__);
        }
        $this->freeText = $freeText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\PersonVotes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
