<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for organisation StructType
 * @subpackage Structs
 */
class Organisation extends AbstractStructBase
{
    /**
     * The orgCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orgCode;
    /**
     * The orgMobilePassword
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orgMobilePassword;
    /**
     * The appIcon
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $appIcon;
    /**
     * The appName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $appName;
    /**
     * Constructor method for organisation
     * @uses Organisation::setOrgCode()
     * @uses Organisation::setOrgMobilePassword()
     * @uses Organisation::setAppIcon()
     * @uses Organisation::setAppName()
     * @param string $orgCode
     * @param string $orgMobilePassword
     * @param string $appIcon
     * @param string $appName
     */
    public function __construct($orgCode = null, $orgMobilePassword = null, $appIcon = null, $appName = null)
    {
        $this
            ->setOrgCode($orgCode)
            ->setOrgMobilePassword($orgMobilePassword)
            ->setAppIcon($appIcon)
            ->setAppName($appName);
    }
    /**
     * Get orgCode value
     * @return string|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param string $orgCode
     * @return \QCC\CampusM\CloudService\StructType\Organisation
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: string
        if (!is_null($orgCode) && !is_string($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get orgMobilePassword value
     * @return string|null
     */
    public function getOrgMobilePassword()
    {
        return $this->orgMobilePassword;
    }
    /**
     * Set orgMobilePassword value
     * @param string $orgMobilePassword
     * @return \QCC\CampusM\CloudService\StructType\Organisation
     */
    public function setOrgMobilePassword($orgMobilePassword = null)
    {
        // validation for constraint: string
        if (!is_null($orgMobilePassword) && !is_string($orgMobilePassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orgMobilePassword)), __LINE__);
        }
        $this->orgMobilePassword = $orgMobilePassword;
        return $this;
    }
    /**
     * Get appIcon value
     * @return string|null
     */
    public function getAppIcon()
    {
        return $this->appIcon;
    }
    /**
     * Set appIcon value
     * @param string $appIcon
     * @return \QCC\CampusM\CloudService\StructType\Organisation
     */
    public function setAppIcon($appIcon = null)
    {
        // validation for constraint: string
        if (!is_null($appIcon) && !is_string($appIcon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($appIcon)), __LINE__);
        }
        $this->appIcon = $appIcon;
        return $this;
    }
    /**
     * Get appName value
     * @return string|null
     */
    public function getAppName()
    {
        return $this->appName;
    }
    /**
     * Set appName value
     * @param string $appName
     * @return \QCC\CampusM\CloudService\StructType\Organisation
     */
    public function setAppName($appName = null)
    {
        // validation for constraint: string
        if (!is_null($appName) && !is_string($appName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($appName)), __LINE__);
        }
        $this->appName = $appName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\Organisation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
