<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for options StructType
 * @subpackage Structs
 */
class Options extends AbstractStructBase
{
    /**
     * The option
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\Option[]
     */
    public $option;
    /**
     * Constructor method for options
     * @uses Options::setOption()
     * @param \QCC\CampusM\CloudService\StructType\Option[] $option
     */
    public function __construct(array $option = array())
    {
        $this
            ->setOption($option);
    }
    /**
     * Get option value
     * @return \QCC\CampusM\CloudService\StructType\Option[]|null
     */
    public function getOption()
    {
        return $this->option;
    }
    /**
     * Set option value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\Option[] $option
     * @return \QCC\CampusM\CloudService\StructType\Options
     */
    public function setOption(array $option = array())
    {
        foreach ($option as $optionsOptionItem) {
            // validation for constraint: itemType
            if (!$optionsOptionItem instanceof \QCC\CampusM\CloudService\StructType\Option) {
                throw new \InvalidArgumentException(sprintf('The option property can only contain items of \QCC\CampusM\CloudService\StructType\Option, "%s" given', is_object($optionsOptionItem) ? get_class($optionsOptionItem) : gettype($optionsOptionItem)), __LINE__);
            }
        }
        $this->option = $option;
        return $this;
    }
    /**
     * Add item to option value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\Option $item
     * @return \QCC\CampusM\CloudService\StructType\Options
     */
    public function addToOption(\QCC\CampusM\CloudService\StructType\Option $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \QCC\CampusM\CloudService\StructType\Option) {
            throw new \InvalidArgumentException(sprintf('The option property can only contain items of \QCC\CampusM\CloudService\StructType\Option, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->option[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\Options
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
