<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for oAuthReturnStatus StructType
 * Meta informations extracted from the WSDL
 * - type: oAuthReturnStatus
 * @subpackage Structs
 */
class OAuthReturnStatus extends ReturnStatus
{
    /**
     * The oAuthHttpStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $oAuthHttpStatus;
    /**
     * The oAuthError
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $oAuthError;
    /**
     * The oAuthErrorDesc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $oAuthErrorDesc;
    /**
     * The oAuthErrorUri
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $oAuthErrorUri;
    /**
     * The oAuthWWWAuthenticateHeader
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $oAuthWWWAuthenticateHeader;
    /**
     * Constructor method for oAuthReturnStatus
     * @uses OAuthReturnStatus::setOAuthHttpStatus()
     * @uses OAuthReturnStatus::setOAuthError()
     * @uses OAuthReturnStatus::setOAuthErrorDesc()
     * @uses OAuthReturnStatus::setOAuthErrorUri()
     * @uses OAuthReturnStatus::setOAuthWWWAuthenticateHeader()
     * @param int $oAuthHttpStatus
     * @param string $oAuthError
     * @param string $oAuthErrorDesc
     * @param string $oAuthErrorUri
     * @param string $oAuthWWWAuthenticateHeader
     */
    public function __construct($oAuthHttpStatus = null, $oAuthError = null, $oAuthErrorDesc = null, $oAuthErrorUri = null, $oAuthWWWAuthenticateHeader = null)
    {
        $this
            ->setOAuthHttpStatus($oAuthHttpStatus)
            ->setOAuthError($oAuthError)
            ->setOAuthErrorDesc($oAuthErrorDesc)
            ->setOAuthErrorUri($oAuthErrorUri)
            ->setOAuthWWWAuthenticateHeader($oAuthWWWAuthenticateHeader);
    }
    /**
     * Get oAuthHttpStatus value
     * @return int|null
     */
    public function getOAuthHttpStatus()
    {
        return $this->oAuthHttpStatus;
    }
    /**
     * Set oAuthHttpStatus value
     * @param int $oAuthHttpStatus
     * @return \QCC\CampusM\CloudService\StructType\OAuthReturnStatus
     */
    public function setOAuthHttpStatus($oAuthHttpStatus = null)
    {
        // validation for constraint: int
        if (!is_null($oAuthHttpStatus) && !is_numeric($oAuthHttpStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($oAuthHttpStatus)), __LINE__);
        }
        $this->oAuthHttpStatus = $oAuthHttpStatus;
        return $this;
    }
    /**
     * Get oAuthError value
     * @return string|null
     */
    public function getOAuthError()
    {
        return $this->oAuthError;
    }
    /**
     * Set oAuthError value
     * @param string $oAuthError
     * @return \QCC\CampusM\CloudService\StructType\OAuthReturnStatus
     */
    public function setOAuthError($oAuthError = null)
    {
        // validation for constraint: string
        if (!is_null($oAuthError) && !is_string($oAuthError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oAuthError)), __LINE__);
        }
        $this->oAuthError = $oAuthError;
        return $this;
    }
    /**
     * Get oAuthErrorDesc value
     * @return string|null
     */
    public function getOAuthErrorDesc()
    {
        return $this->oAuthErrorDesc;
    }
    /**
     * Set oAuthErrorDesc value
     * @param string $oAuthErrorDesc
     * @return \QCC\CampusM\CloudService\StructType\OAuthReturnStatus
     */
    public function setOAuthErrorDesc($oAuthErrorDesc = null)
    {
        // validation for constraint: string
        if (!is_null($oAuthErrorDesc) && !is_string($oAuthErrorDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oAuthErrorDesc)), __LINE__);
        }
        $this->oAuthErrorDesc = $oAuthErrorDesc;
        return $this;
    }
    /**
     * Get oAuthErrorUri value
     * @return string|null
     */
    public function getOAuthErrorUri()
    {
        return $this->oAuthErrorUri;
    }
    /**
     * Set oAuthErrorUri value
     * @param string $oAuthErrorUri
     * @return \QCC\CampusM\CloudService\StructType\OAuthReturnStatus
     */
    public function setOAuthErrorUri($oAuthErrorUri = null)
    {
        // validation for constraint: string
        if (!is_null($oAuthErrorUri) && !is_string($oAuthErrorUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oAuthErrorUri)), __LINE__);
        }
        $this->oAuthErrorUri = $oAuthErrorUri;
        return $this;
    }
    /**
     * Get oAuthWWWAuthenticateHeader value
     * @return string|null
     */
    public function getOAuthWWWAuthenticateHeader()
    {
        return $this->oAuthWWWAuthenticateHeader;
    }
    /**
     * Set oAuthWWWAuthenticateHeader value
     * @param string $oAuthWWWAuthenticateHeader
     * @return \QCC\CampusM\CloudService\StructType\OAuthReturnStatus
     */
    public function setOAuthWWWAuthenticateHeader($oAuthWWWAuthenticateHeader = null)
    {
        // validation for constraint: string
        if (!is_null($oAuthWWWAuthenticateHeader) && !is_string($oAuthWWWAuthenticateHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oAuthWWWAuthenticateHeader)), __LINE__);
        }
        $this->oAuthWWWAuthenticateHeader = $oAuthWWWAuthenticateHeader;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\OAuthReturnStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
