<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for notification StructType
 * @subpackage Structs
 */
class Notification extends AbstractStructBase
{
    /**
     * The notificationTargets
     * @var \QCC\CampusM\CloudService\StructType\NotificationTargets
     */
    public $notificationTargets;
    /**
     * The note
     * @var string
     */
    public $note;
    /**
     * The message
     * @var string
     */
    public $message;
    /**
     * The forceSms
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $forceSms;
    /**
     * The forceEmail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $forceEmail;
    /**
     * The forceCampusmNotification
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $forceCampusmNotification;
    /**
     * The priority
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $priority;
    /**
     * The category
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $category;
    /**
     * The expiry
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $expiry;
    /**
     * The integratedAlertDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $integratedAlertDate;
    /**
     * The actionParameter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $actionParameter;
    /**
     * The tag
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tag;
    /**
     * The sendAt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sendAt;
    /**
     * Constructor method for notification
     * @uses Notification::setNotificationTargets()
     * @uses Notification::setNote()
     * @uses Notification::setMessage()
     * @uses Notification::setForceSms()
     * @uses Notification::setForceEmail()
     * @uses Notification::setForceCampusmNotification()
     * @uses Notification::setPriority()
     * @uses Notification::setCategory()
     * @uses Notification::setExpiry()
     * @uses Notification::setIntegratedAlertDate()
     * @uses Notification::setActionParameter()
     * @uses Notification::setTag()
     * @uses Notification::setSendAt()
     * @param \QCC\CampusM\CloudService\StructType\NotificationTargets $notificationTargets
     * @param string $note
     * @param string $message
     * @param string $forceSms
     * @param string $forceEmail
     * @param string $forceCampusmNotification
     * @param string $priority
     * @param string $category
     * @param int $expiry
     * @param string $integratedAlertDate
     * @param string $actionParameter
     * @param string $tag
     * @param string $sendAt
     */
    public function __construct(\QCC\CampusM\CloudService\StructType\NotificationTargets $notificationTargets = null, $note = null, $message = null, $forceSms = null, $forceEmail = null, $forceCampusmNotification = null, $priority = null, $category = null, $expiry = null, $integratedAlertDate = null, $actionParameter = null, $tag = null, $sendAt = null)
    {
        $this
            ->setNotificationTargets($notificationTargets)
            ->setNote($note)
            ->setMessage($message)
            ->setForceSms($forceSms)
            ->setForceEmail($forceEmail)
            ->setForceCampusmNotification($forceCampusmNotification)
            ->setPriority($priority)
            ->setCategory($category)
            ->setExpiry($expiry)
            ->setIntegratedAlertDate($integratedAlertDate)
            ->setActionParameter($actionParameter)
            ->setTag($tag)
            ->setSendAt($sendAt);
    }
    /**
     * Get notificationTargets value
     * @return \QCC\CampusM\CloudService\StructType\NotificationTargets|null
     */
    public function getNotificationTargets()
    {
        return $this->notificationTargets;
    }
    /**
     * Set notificationTargets value
     * @param \QCC\CampusM\CloudService\StructType\NotificationTargets $notificationTargets
     * @return \QCC\CampusM\CloudService\StructType\Notification
     */
    public function setNotificationTargets(\QCC\CampusM\CloudService\StructType\NotificationTargets $notificationTargets = null)
    {
        $this->notificationTargets = $notificationTargets;
        return $this;
    }
    /**
     * Get note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->note;
    }
    /**
     * Set note value
     * @param string $note
     * @return \QCC\CampusM\CloudService\StructType\Notification
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($note)), __LINE__);
        }
        $this->note = $note;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \QCC\CampusM\CloudService\StructType\Notification
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get forceSms value
     * @return string|null
     */
    public function getForceSms()
    {
        return $this->forceSms;
    }
    /**
     * Set forceSms value
     * @param string $forceSms
     * @return \QCC\CampusM\CloudService\StructType\Notification
     */
    public function setForceSms($forceSms = null)
    {
        // validation for constraint: string
        if (!is_null($forceSms) && !is_string($forceSms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($forceSms)), __LINE__);
        }
        $this->forceSms = $forceSms;
        return $this;
    }
    /**
     * Get forceEmail value
     * @return string|null
     */
    public function getForceEmail()
    {
        return $this->forceEmail;
    }
    /**
     * Set forceEmail value
     * @param string $forceEmail
     * @return \QCC\CampusM\CloudService\StructType\Notification
     */
    public function setForceEmail($forceEmail = null)
    {
        // validation for constraint: string
        if (!is_null($forceEmail) && !is_string($forceEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($forceEmail)), __LINE__);
        }
        $this->forceEmail = $forceEmail;
        return $this;
    }
    /**
     * Get forceCampusmNotification value
     * @return string|null
     */
    public function getForceCampusmNotification()
    {
        return $this->forceCampusmNotification;
    }
    /**
     * Set forceCampusmNotification value
     * @param string $forceCampusmNotification
     * @return \QCC\CampusM\CloudService\StructType\Notification
     */
    public function setForceCampusmNotification($forceCampusmNotification = null)
    {
        // validation for constraint: string
        if (!is_null($forceCampusmNotification) && !is_string($forceCampusmNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($forceCampusmNotification)), __LINE__);
        }
        $this->forceCampusmNotification = $forceCampusmNotification;
        return $this;
    }
    /**
     * Get priority value
     * @return string|null
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @param string $priority
     * @return \QCC\CampusM\CloudService\StructType\Notification
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: string
        if (!is_null($priority) && !is_string($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($priority)), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \QCC\CampusM\CloudService\StructType\Notification
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get expiry value
     * @return int|null
     */
    public function getExpiry()
    {
        return $this->expiry;
    }
    /**
     * Set expiry value
     * @param int $expiry
     * @return \QCC\CampusM\CloudService\StructType\Notification
     */
    public function setExpiry($expiry = null)
    {
        // validation for constraint: int
        if (!is_null($expiry) && !is_numeric($expiry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($expiry)), __LINE__);
        }
        $this->expiry = $expiry;
        return $this;
    }
    /**
     * Get integratedAlertDate value
     * @return string|null
     */
    public function getIntegratedAlertDate()
    {
        return $this->integratedAlertDate;
    }
    /**
     * Set integratedAlertDate value
     * @param string $integratedAlertDate
     * @return \QCC\CampusM\CloudService\StructType\Notification
     */
    public function setIntegratedAlertDate($integratedAlertDate = null)
    {
        // validation for constraint: string
        if (!is_null($integratedAlertDate) && !is_string($integratedAlertDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($integratedAlertDate)), __LINE__);
        }
        $this->integratedAlertDate = $integratedAlertDate;
        return $this;
    }
    /**
     * Get actionParameter value
     * @return string|null
     */
    public function getActionParameter()
    {
        return $this->actionParameter;
    }
    /**
     * Set actionParameter value
     * @param string $actionParameter
     * @return \QCC\CampusM\CloudService\StructType\Notification
     */
    public function setActionParameter($actionParameter = null)
    {
        // validation for constraint: string
        if (!is_null($actionParameter) && !is_string($actionParameter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actionParameter)), __LINE__);
        }
        $this->actionParameter = $actionParameter;
        return $this;
    }
    /**
     * Get tag value
     * @return string|null
     */
    public function getTag()
    {
        return $this->tag;
    }
    /**
     * Set tag value
     * @param string $tag
     * @return \QCC\CampusM\CloudService\StructType\Notification
     */
    public function setTag($tag = null)
    {
        // validation for constraint: string
        if (!is_null($tag) && !is_string($tag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tag)), __LINE__);
        }
        $this->tag = $tag;
        return $this;
    }
    /**
     * Get sendAt value
     * @return string|null
     */
    public function getSendAt()
    {
        return $this->sendAt;
    }
    /**
     * Set sendAt value
     * @param string $sendAt
     * @return \QCC\CampusM\CloudService\StructType\Notification
     */
    public function setSendAt($sendAt = null)
    {
        // validation for constraint: string
        if (!is_null($sendAt) && !is_string($sendAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sendAt)), __LINE__);
        }
        $this->sendAt = $sendAt;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\Notification
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
