<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for myLocationOptionsRequest StructType
 * @subpackage Structs
 */
class MyLocationOptionsRequest extends AbstractStructBase
{
    /**
     * The personId
     * @var int
     */
    public $personId;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The shareLocation
     * @var string
     */
    public $shareLocation;
    /**
     * The updateLocation
     * @var int
     */
    public $updateLocation;
    /**
     * Constructor method for myLocationOptionsRequest
     * @uses MyLocationOptionsRequest::setPersonId()
     * @uses MyLocationOptionsRequest::setPassword()
     * @uses MyLocationOptionsRequest::setShareLocation()
     * @uses MyLocationOptionsRequest::setUpdateLocation()
     * @param int $personId
     * @param string $password
     * @param string $shareLocation
     * @param int $updateLocation
     */
    public function __construct($personId = null, $password = null, $shareLocation = null, $updateLocation = null)
    {
        $this
            ->setPersonId($personId)
            ->setPassword($password)
            ->setShareLocation($shareLocation)
            ->setUpdateLocation($updateLocation);
    }
    /**
     * Get personId value
     * @return int|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param int $personId
     * @return \QCC\CampusM\CloudService\StructType\MyLocationOptionsRequest
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: int
        if (!is_null($personId) && !is_numeric($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \QCC\CampusM\CloudService\StructType\MyLocationOptionsRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get shareLocation value
     * @return string|null
     */
    public function getShareLocation()
    {
        return $this->shareLocation;
    }
    /**
     * Set shareLocation value
     * @param string $shareLocation
     * @return \QCC\CampusM\CloudService\StructType\MyLocationOptionsRequest
     */
    public function setShareLocation($shareLocation = null)
    {
        // validation for constraint: string
        if (!is_null($shareLocation) && !is_string($shareLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareLocation)), __LINE__);
        }
        $this->shareLocation = $shareLocation;
        return $this;
    }
    /**
     * Get updateLocation value
     * @return int|null
     */
    public function getUpdateLocation()
    {
        return $this->updateLocation;
    }
    /**
     * Set updateLocation value
     * @param int $updateLocation
     * @return \QCC\CampusM\CloudService\StructType\MyLocationOptionsRequest
     */
    public function setUpdateLocation($updateLocation = null)
    {
        // validation for constraint: int
        if (!is_null($updateLocation) && !is_numeric($updateLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($updateLocation)), __LINE__);
        }
        $this->updateLocation = $updateLocation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\MyLocationOptionsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
