<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for moduleSettings StructType
 * @subpackage Structs
 */
class ModuleSettings extends AbstractStructBase
{
    /**
     * The setting
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\ModuleSetting[]
     */
    public $setting;
    /**
     * Constructor method for moduleSettings
     * @uses ModuleSettings::setSetting()
     * @param \QCC\CampusM\CloudService\StructType\ModuleSetting[] $setting
     */
    public function __construct(array $setting = array())
    {
        $this
            ->setSetting($setting);
    }
    /**
     * Get setting value
     * @return \QCC\CampusM\CloudService\StructType\ModuleSetting[]|null
     */
    public function getSetting()
    {
        return $this->setting;
    }
    /**
     * Set setting value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\ModuleSetting[] $setting
     * @return \QCC\CampusM\CloudService\StructType\ModuleSettings
     */
    public function setSetting(array $setting = array())
    {
        foreach ($setting as $moduleSettingsSettingItem) {
            // validation for constraint: itemType
            if (!$moduleSettingsSettingItem instanceof \QCC\CampusM\CloudService\StructType\ModuleSetting) {
                throw new \InvalidArgumentException(sprintf('The setting property can only contain items of \QCC\CampusM\CloudService\StructType\ModuleSetting, "%s" given', is_object($moduleSettingsSettingItem) ? get_class($moduleSettingsSettingItem) : gettype($moduleSettingsSettingItem)), __LINE__);
            }
        }
        $this->setting = $setting;
        return $this;
    }
    /**
     * Add item to setting value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\ModuleSetting $item
     * @return \QCC\CampusM\CloudService\StructType\ModuleSettings
     */
    public function addToSetting(\QCC\CampusM\CloudService\StructType\ModuleSetting $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \QCC\CampusM\CloudService\StructType\ModuleSetting) {
            throw new \InvalidArgumentException(sprintf('The setting property can only contain items of \QCC\CampusM\CloudService\StructType\ModuleSetting, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->setting[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\ModuleSettings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
