<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for menu StructType
 * @subpackage Structs
 */
class Menu extends AbstractStructBase
{
    /**
     * The mitem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\Mitem[]
     */
    public $mitem;
    /**
     * Constructor method for menu
     * @uses Menu::setMitem()
     * @param \QCC\CampusM\CloudService\StructType\Mitem[] $mitem
     */
    public function __construct(array $mitem = array())
    {
        $this
            ->setMitem($mitem);
    }
    /**
     * Get mitem value
     * @return \QCC\CampusM\CloudService\StructType\Mitem[]|null
     */
    public function getMitem()
    {
        return $this->mitem;
    }
    /**
     * Set mitem value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\Mitem[] $mitem
     * @return \QCC\CampusM\CloudService\StructType\Menu
     */
    public function setMitem(array $mitem = array())
    {
        foreach ($mitem as $menuMitemItem) {
            // validation for constraint: itemType
            if (!$menuMitemItem instanceof \QCC\CampusM\CloudService\StructType\Mitem) {
                throw new \InvalidArgumentException(sprintf('The mitem property can only contain items of \QCC\CampusM\CloudService\StructType\Mitem, "%s" given', is_object($menuMitemItem) ? get_class($menuMitemItem) : gettype($menuMitemItem)), __LINE__);
            }
        }
        $this->mitem = $mitem;
        return $this;
    }
    /**
     * Add item to mitem value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\Mitem $item
     * @return \QCC\CampusM\CloudService\StructType\Menu
     */
    public function addToMitem(\QCC\CampusM\CloudService\StructType\Mitem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \QCC\CampusM\CloudService\StructType\Mitem) {
            throw new \InvalidArgumentException(sprintf('The mitem property can only contain items of \QCC\CampusM\CloudService\StructType\Mitem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->mitem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\Menu
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
