<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mapItem StructType
 * @subpackage Structs
 */
class MapItem extends AbstractStructBase
{
    /**
     * The map
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\Map
     */
    public $map;
    /**
     * The locations
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\Locations[]
     */
    public $locations;
    /**
     * Constructor method for mapItem
     * @uses MapItem::setMap()
     * @uses MapItem::setLocations()
     * @param \QCC\CampusM\CloudService\StructType\Map $map
     * @param \QCC\CampusM\CloudService\StructType\Locations[] $locations
     */
    public function __construct(\QCC\CampusM\CloudService\StructType\Map $map = null, array $locations = array())
    {
        $this
            ->setMap($map)
            ->setLocations($locations);
    }
    /**
     * Get map value
     * @return \QCC\CampusM\CloudService\StructType\Map|null
     */
    public function getMap()
    {
        return $this->map;
    }
    /**
     * Set map value
     * @param \QCC\CampusM\CloudService\StructType\Map $map
     * @return \QCC\CampusM\CloudService\StructType\MapItem
     */
    public function setMap(\QCC\CampusM\CloudService\StructType\Map $map = null)
    {
        $this->map = $map;
        return $this;
    }
    /**
     * Get locations value
     * @return \QCC\CampusM\CloudService\StructType\Locations[]|null
     */
    public function getLocations()
    {
        return $this->locations;
    }
    /**
     * Set locations value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\Locations[] $locations
     * @return \QCC\CampusM\CloudService\StructType\MapItem
     */
    public function setLocations(array $locations = array())
    {
        foreach ($locations as $mapItemLocationsItem) {
            // validation for constraint: itemType
            if (!$mapItemLocationsItem instanceof \QCC\CampusM\CloudService\StructType\Locations) {
                throw new \InvalidArgumentException(sprintf('The locations property can only contain items of \QCC\CampusM\CloudService\StructType\Locations, "%s" given', is_object($mapItemLocationsItem) ? get_class($mapItemLocationsItem) : gettype($mapItemLocationsItem)), __LINE__);
            }
        }
        $this->locations = $locations;
        return $this;
    }
    /**
     * Add item to locations value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\Locations $item
     * @return \QCC\CampusM\CloudService\StructType\MapItem
     */
    public function addToLocations(\QCC\CampusM\CloudService\StructType\Locations $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \QCC\CampusM\CloudService\StructType\Locations) {
            throw new \InvalidArgumentException(sprintf('The locations property can only contain items of \QCC\CampusM\CloudService\StructType\Locations, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->locations[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\MapItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
