<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for locationCategoriesRequest StructType
 * @subpackage Structs
 */
class LocationCategoriesRequest extends AbstractStructBase
{
    /**
     * The orgCode
     * @var int
     */
    public $orgCode;
    /**
     * The personId
     * @var int
     */
    public $personId;
    /**
     * The profileId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $profileId;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The mapCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mapCode;
    /**
     * Constructor method for locationCategoriesRequest
     * @uses LocationCategoriesRequest::setOrgCode()
     * @uses LocationCategoriesRequest::setPersonId()
     * @uses LocationCategoriesRequest::setProfileId()
     * @uses LocationCategoriesRequest::setPassword()
     * @uses LocationCategoriesRequest::setMapCode()
     * @param int $orgCode
     * @param int $personId
     * @param int $profileId
     * @param string $password
     * @param string $mapCode
     */
    public function __construct($orgCode = null, $personId = null, $profileId = null, $password = null, $mapCode = null)
    {
        $this
            ->setOrgCode($orgCode)
            ->setPersonId($personId)
            ->setProfileId($profileId)
            ->setPassword($password)
            ->setMapCode($mapCode);
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\LocationCategoriesRequest
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get personId value
     * @return int|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param int $personId
     * @return \QCC\CampusM\CloudService\StructType\LocationCategoriesRequest
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: int
        if (!is_null($personId) && !is_numeric($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Get profileId value
     * @return int|null
     */
    public function getProfileId()
    {
        return $this->profileId;
    }
    /**
     * Set profileId value
     * @param int $profileId
     * @return \QCC\CampusM\CloudService\StructType\LocationCategoriesRequest
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !is_numeric($profileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($profileId)), __LINE__);
        }
        $this->profileId = $profileId;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \QCC\CampusM\CloudService\StructType\LocationCategoriesRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get mapCode value
     * @return string|null
     */
    public function getMapCode()
    {
        return $this->mapCode;
    }
    /**
     * Set mapCode value
     * @param string $mapCode
     * @return \QCC\CampusM\CloudService\StructType\LocationCategoriesRequest
     */
    public function setMapCode($mapCode = null)
    {
        // validation for constraint: string
        if (!is_null($mapCode) && !is_string($mapCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mapCode)), __LINE__);
        }
        $this->mapCode = $mapCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\LocationCategoriesRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
