<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for listAvailableOrganisationsResponse StructType
 * @subpackage Structs
 */
class ListAvailableOrganisationsResponse extends AbstractStructBase
{
    /**
     * The organisations
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\Organisation[]
     */
    public $organisations;
    /**
     * Constructor method for listAvailableOrganisationsResponse
     * @uses ListAvailableOrganisationsResponse::setOrganisations()
     * @param \QCC\CampusM\CloudService\StructType\Organisation[] $organisations
     */
    public function __construct(array $organisations = array())
    {
        $this
            ->setOrganisations($organisations);
    }
    /**
     * Get organisations value
     * @return \QCC\CampusM\CloudService\StructType\Organisation[]|null
     */
    public function getOrganisations()
    {
        return $this->organisations;
    }
    /**
     * Set organisations value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\Organisation[] $organisations
     * @return \QCC\CampusM\CloudService\StructType\ListAvailableOrganisationsResponse
     */
    public function setOrganisations(array $organisations = array())
    {
        foreach ($organisations as $listAvailableOrganisationsResponseOrganisationsItem) {
            // validation for constraint: itemType
            if (!$listAvailableOrganisationsResponseOrganisationsItem instanceof \QCC\CampusM\CloudService\StructType\Organisation) {
                throw new \InvalidArgumentException(sprintf('The organisations property can only contain items of \QCC\CampusM\CloudService\StructType\Organisation, "%s" given', is_object($listAvailableOrganisationsResponseOrganisationsItem) ? get_class($listAvailableOrganisationsResponseOrganisationsItem) : gettype($listAvailableOrganisationsResponseOrganisationsItem)), __LINE__);
            }
        }
        $this->organisations = $organisations;
        return $this;
    }
    /**
     * Add item to organisations value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\Organisation $item
     * @return \QCC\CampusM\CloudService\StructType\ListAvailableOrganisationsResponse
     */
    public function addToOrganisations(\QCC\CampusM\CloudService\StructType\Organisation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \QCC\CampusM\CloudService\StructType\Organisation) {
            throw new \InvalidArgumentException(sprintf('The organisations property can only contain items of \QCC\CampusM\CloudService\StructType\Organisation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->organisations[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\ListAvailableOrganisationsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
