<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for javascriptItem StructType
 * @subpackage Structs
 */
class JavascriptItem extends AbstractStructBase
{
    /**
     * The javascriptUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $javascriptUrl;
    /**
     * The javascriptContent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $javascriptContent;
    /**
     * Constructor method for javascriptItem
     * @uses JavascriptItem::setJavascriptUrl()
     * @uses JavascriptItem::setJavascriptContent()
     * @param string $javascriptUrl
     * @param string $javascriptContent
     */
    public function __construct($javascriptUrl = null, $javascriptContent = null)
    {
        $this
            ->setJavascriptUrl($javascriptUrl)
            ->setJavascriptContent($javascriptContent);
    }
    /**
     * Get javascriptUrl value
     * @return string|null
     */
    public function getJavascriptUrl()
    {
        return $this->javascriptUrl;
    }
    /**
     * Set javascriptUrl value
     * @param string $javascriptUrl
     * @return \QCC\CampusM\CloudService\StructType\JavascriptItem
     */
    public function setJavascriptUrl($javascriptUrl = null)
    {
        // validation for constraint: string
        if (!is_null($javascriptUrl) && !is_string($javascriptUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($javascriptUrl)), __LINE__);
        }
        $this->javascriptUrl = $javascriptUrl;
        return $this;
    }
    /**
     * Get javascriptContent value
     * @return string|null
     */
    public function getJavascriptContent()
    {
        return $this->javascriptContent;
    }
    /**
     * Set javascriptContent value
     * @param string $javascriptContent
     * @return \QCC\CampusM\CloudService\StructType\JavascriptItem
     */
    public function setJavascriptContent($javascriptContent = null)
    {
        // validation for constraint: string
        if (!is_null($javascriptContent) && !is_string($javascriptContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($javascriptContent)), __LINE__);
        }
        $this->javascriptContent = $javascriptContent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\JavascriptItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
