<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for insertXmlRequest StructType
 * @subpackage Structs
 */
class InsertXmlRequest extends AbstractStructBase
{
    /**
     * The orgCode
     * @var int
     */
    public $orgCode;
    /**
     * The orgServicePassword
     * @var string
     */
    public $orgServicePassword;
    /**
     * The url
     * @var string
     */
    public $url;
    /**
     * Constructor method for insertXmlRequest
     * @uses InsertXmlRequest::setOrgCode()
     * @uses InsertXmlRequest::setOrgServicePassword()
     * @uses InsertXmlRequest::setUrl()
     * @param int $orgCode
     * @param string $orgServicePassword
     * @param string $url
     */
    public function __construct($orgCode = null, $orgServicePassword = null, $url = null)
    {
        $this
            ->setOrgCode($orgCode)
            ->setOrgServicePassword($orgServicePassword)
            ->setUrl($url);
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\InsertXmlRequest
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get orgServicePassword value
     * @return string|null
     */
    public function getOrgServicePassword()
    {
        return $this->orgServicePassword;
    }
    /**
     * Set orgServicePassword value
     * @param string $orgServicePassword
     * @return \QCC\CampusM\CloudService\StructType\InsertXmlRequest
     */
    public function setOrgServicePassword($orgServicePassword = null)
    {
        // validation for constraint: string
        if (!is_null($orgServicePassword) && !is_string($orgServicePassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orgServicePassword)), __LINE__);
        }
        $this->orgServicePassword = $orgServicePassword;
        return $this;
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \QCC\CampusM\CloudService\StructType\InsertXmlRequest
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\InsertXmlRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
