<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for hostConfigRequest StructType
 * @subpackage Structs
 */
class HostConfigRequest extends AbstractStructBase
{
    /**
     * The orgCode
     * @var int
     */
    public $orgCode;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The profileId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $profileId;
    /**
     * The roleIds
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\RoleIds
     */
    public $roleIds;
    /**
     * Constructor method for hostConfigRequest
     * @uses HostConfigRequest::setOrgCode()
     * @uses HostConfigRequest::setPassword()
     * @uses HostConfigRequest::setProfileId()
     * @uses HostConfigRequest::setRoleIds()
     * @param int $orgCode
     * @param string $password
     * @param int $profileId
     * @param \QCC\CampusM\CloudService\StructType\RoleIds $roleIds
     */
    public function __construct($orgCode = null, $password = null, $profileId = null, \QCC\CampusM\CloudService\StructType\RoleIds $roleIds = null)
    {
        $this
            ->setOrgCode($orgCode)
            ->setPassword($password)
            ->setProfileId($profileId)
            ->setRoleIds($roleIds);
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\HostConfigRequest
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \QCC\CampusM\CloudService\StructType\HostConfigRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get profileId value
     * @return int|null
     */
    public function getProfileId()
    {
        return $this->profileId;
    }
    /**
     * Set profileId value
     * @param int $profileId
     * @return \QCC\CampusM\CloudService\StructType\HostConfigRequest
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !is_numeric($profileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($profileId)), __LINE__);
        }
        $this->profileId = $profileId;
        return $this;
    }
    /**
     * Get roleIds value
     * @return \QCC\CampusM\CloudService\StructType\RoleIds|null
     */
    public function getRoleIds()
    {
        return $this->roleIds;
    }
    /**
     * Set roleIds value
     * @param \QCC\CampusM\CloudService\StructType\RoleIds $roleIds
     * @return \QCC\CampusM\CloudService\StructType\HostConfigRequest
     */
    public function setRoleIds(\QCC\CampusM\CloudService\StructType\RoleIds $roleIds = null)
    {
        $this->roleIds = $roleIds;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\HostConfigRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
