<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for guideItems StructType
 * @subpackage Structs
 */
class GuideItems extends AbstractStructBase
{
    /**
     * The menuCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $menuCode;
    /**
     * The menuName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $menuName;
    /**
     * The pgitem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\Pgitem[]
     */
    public $pgitem;
    /**
     * Constructor method for guideItems
     * @uses GuideItems::setMenuCode()
     * @uses GuideItems::setMenuName()
     * @uses GuideItems::setPgitem()
     * @param int $menuCode
     * @param string $menuName
     * @param \QCC\CampusM\CloudService\StructType\Pgitem[] $pgitem
     */
    public function __construct($menuCode = null, $menuName = null, array $pgitem = array())
    {
        $this
            ->setMenuCode($menuCode)
            ->setMenuName($menuName)
            ->setPgitem($pgitem);
    }
    /**
     * Get menuCode value
     * @return int|null
     */
    public function getMenuCode()
    {
        return $this->menuCode;
    }
    /**
     * Set menuCode value
     * @param int $menuCode
     * @return \QCC\CampusM\CloudService\StructType\GuideItems
     */
    public function setMenuCode($menuCode = null)
    {
        // validation for constraint: int
        if (!is_null($menuCode) && !is_numeric($menuCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($menuCode)), __LINE__);
        }
        $this->menuCode = $menuCode;
        return $this;
    }
    /**
     * Get menuName value
     * @return string|null
     */
    public function getMenuName()
    {
        return $this->menuName;
    }
    /**
     * Set menuName value
     * @param string $menuName
     * @return \QCC\CampusM\CloudService\StructType\GuideItems
     */
    public function setMenuName($menuName = null)
    {
        // validation for constraint: string
        if (!is_null($menuName) && !is_string($menuName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($menuName)), __LINE__);
        }
        $this->menuName = $menuName;
        return $this;
    }
    /**
     * Get pgitem value
     * @return \QCC\CampusM\CloudService\StructType\Pgitem[]|null
     */
    public function getPgitem()
    {
        return $this->pgitem;
    }
    /**
     * Set pgitem value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\Pgitem[] $pgitem
     * @return \QCC\CampusM\CloudService\StructType\GuideItems
     */
    public function setPgitem(array $pgitem = array())
    {
        foreach ($pgitem as $guideItemsPgitemItem) {
            // validation for constraint: itemType
            if (!$guideItemsPgitemItem instanceof \QCC\CampusM\CloudService\StructType\Pgitem) {
                throw new \InvalidArgumentException(sprintf('The pgitem property can only contain items of \QCC\CampusM\CloudService\StructType\Pgitem, "%s" given', is_object($guideItemsPgitemItem) ? get_class($guideItemsPgitemItem) : gettype($guideItemsPgitemItem)), __LINE__);
            }
        }
        $this->pgitem = $pgitem;
        return $this;
    }
    /**
     * Add item to pgitem value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\Pgitem $item
     * @return \QCC\CampusM\CloudService\StructType\GuideItems
     */
    public function addToPgitem(\QCC\CampusM\CloudService\StructType\Pgitem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \QCC\CampusM\CloudService\StructType\Pgitem) {
            throw new \InvalidArgumentException(sprintf('The pgitem property can only contain items of \QCC\CampusM\CloudService\StructType\Pgitem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->pgitem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\GuideItems
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
