<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for friendGroup StructType
 * @subpackage Structs
 */
class FriendGroup extends AbstractStructBase
{
    /**
     * The groupDescription
     * @var string
     */
    public $groupDescription;
    /**
     * The numberOfFriends
     * @var int
     */
    public $numberOfFriends;
    /**
     * Constructor method for friendGroup
     * @uses FriendGroup::setGroupDescription()
     * @uses FriendGroup::setNumberOfFriends()
     * @param string $groupDescription
     * @param int $numberOfFriends
     */
    public function __construct($groupDescription = null, $numberOfFriends = null)
    {
        $this
            ->setGroupDescription($groupDescription)
            ->setNumberOfFriends($numberOfFriends);
    }
    /**
     * Get groupDescription value
     * @return string|null
     */
    public function getGroupDescription()
    {
        return $this->groupDescription;
    }
    /**
     * Set groupDescription value
     * @param string $groupDescription
     * @return \QCC\CampusM\CloudService\StructType\FriendGroup
     */
    public function setGroupDescription($groupDescription = null)
    {
        // validation for constraint: string
        if (!is_null($groupDescription) && !is_string($groupDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupDescription)), __LINE__);
        }
        $this->groupDescription = $groupDescription;
        return $this;
    }
    /**
     * Get numberOfFriends value
     * @return int|null
     */
    public function getNumberOfFriends()
    {
        return $this->numberOfFriends;
    }
    /**
     * Set numberOfFriends value
     * @param int $numberOfFriends
     * @return \QCC\CampusM\CloudService\StructType\FriendGroup
     */
    public function setNumberOfFriends($numberOfFriends = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfFriends) && !is_numeric($numberOfFriends)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfFriends)), __LINE__);
        }
        $this->numberOfFriends = $numberOfFriends;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\FriendGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
