<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for flowString StructType
 * @subpackage Structs
 */
class FlowString extends AbstractStructBase
{
    /**
     * The keyValue
     * @var string
     */
    public $keyValue;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * Constructor method for flowString
     * @uses FlowString::setKeyValue()
     * @uses FlowString::setDescription()
     * @param string $keyValue
     * @param string $description
     */
    public function __construct($keyValue = null, $description = null)
    {
        $this
            ->setKeyValue($keyValue)
            ->setDescription($description);
    }
    /**
     * Get keyValue value
     * @return string|null
     */
    public function getKeyValue()
    {
        return $this->keyValue;
    }
    /**
     * Set keyValue value
     * @param string $keyValue
     * @return \QCC\CampusM\CloudService\StructType\FlowString
     */
    public function setKeyValue($keyValue = null)
    {
        // validation for constraint: string
        if (!is_null($keyValue) && !is_string($keyValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($keyValue)), __LINE__);
        }
        $this->keyValue = $keyValue;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \QCC\CampusM\CloudService\StructType\FlowString
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\FlowString
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
