<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for flowDetail StructType
 * @subpackage Structs
 */
class FlowDetail extends AbstractStructBase
{
    /**
     * The nativeComponent
     * @var string
     */
    public $nativeComponent;
    /**
     * The flowId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $flowId;
    /**
     * The capturedFlowDatasets
     * @var \QCC\CampusM\CloudService\StructType\CapturedFlowDatasets
     */
    public $capturedFlowDatasets;
    /**
     * Constructor method for flowDetail
     * @uses FlowDetail::setNativeComponent()
     * @uses FlowDetail::setFlowId()
     * @uses FlowDetail::setCapturedFlowDatasets()
     * @param string $nativeComponent
     * @param int $flowId
     * @param \QCC\CampusM\CloudService\StructType\CapturedFlowDatasets $capturedFlowDatasets
     */
    public function __construct($nativeComponent = null, $flowId = null, \QCC\CampusM\CloudService\StructType\CapturedFlowDatasets $capturedFlowDatasets = null)
    {
        $this
            ->setNativeComponent($nativeComponent)
            ->setFlowId($flowId)
            ->setCapturedFlowDatasets($capturedFlowDatasets);
    }
    /**
     * Get nativeComponent value
     * @return string|null
     */
    public function getNativeComponent()
    {
        return $this->nativeComponent;
    }
    /**
     * Set nativeComponent value
     * @param string $nativeComponent
     * @return \QCC\CampusM\CloudService\StructType\FlowDetail
     */
    public function setNativeComponent($nativeComponent = null)
    {
        // validation for constraint: string
        if (!is_null($nativeComponent) && !is_string($nativeComponent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nativeComponent)), __LINE__);
        }
        $this->nativeComponent = $nativeComponent;
        return $this;
    }
    /**
     * Get flowId value
     * @return int|null
     */
    public function getFlowId()
    {
        return $this->flowId;
    }
    /**
     * Set flowId value
     * @param int $flowId
     * @return \QCC\CampusM\CloudService\StructType\FlowDetail
     */
    public function setFlowId($flowId = null)
    {
        // validation for constraint: int
        if (!is_null($flowId) && !is_numeric($flowId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($flowId)), __LINE__);
        }
        $this->flowId = $flowId;
        return $this;
    }
    /**
     * Get capturedFlowDatasets value
     * @return \QCC\CampusM\CloudService\StructType\CapturedFlowDatasets|null
     */
    public function getCapturedFlowDatasets()
    {
        return $this->capturedFlowDatasets;
    }
    /**
     * Set capturedFlowDatasets value
     * @param \QCC\CampusM\CloudService\StructType\CapturedFlowDatasets $capturedFlowDatasets
     * @return \QCC\CampusM\CloudService\StructType\FlowDetail
     */
    public function setCapturedFlowDatasets(\QCC\CampusM\CloudService\StructType\CapturedFlowDatasets $capturedFlowDatasets = null)
    {
        $this->capturedFlowDatasets = $capturedFlowDatasets;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\FlowDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
