<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for findFriendsRequest StructType
 * @subpackage Structs
 */
class FindFriendsRequest extends AbstractStructBase
{
    /**
     * The personId
     * @var int
     */
    public $personId;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $type;
    /**
     * The latitude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $latitude;
    /**
     * The longitude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $longitude;
    /**
     * The group
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $group;
    /**
     * Constructor method for findFriendsRequest
     * @uses FindFriendsRequest::setPersonId()
     * @uses FindFriendsRequest::setPassword()
     * @uses FindFriendsRequest::setType()
     * @uses FindFriendsRequest::setLatitude()
     * @uses FindFriendsRequest::setLongitude()
     * @uses FindFriendsRequest::setGroup()
     * @param int $personId
     * @param string $password
     * @param string $type
     * @param float $latitude
     * @param float $longitude
     * @param string $group
     */
    public function __construct($personId = null, $password = null, $type = null, $latitude = null, $longitude = null, $group = null)
    {
        $this
            ->setPersonId($personId)
            ->setPassword($password)
            ->setType($type)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setGroup($group);
    }
    /**
     * Get personId value
     * @return int|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param int $personId
     * @return \QCC\CampusM\CloudService\StructType\FindFriendsRequest
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: int
        if (!is_null($personId) && !is_numeric($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \QCC\CampusM\CloudService\StructType\FindFriendsRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->type) ? $this->type : null;
    }
    /**
     * Set type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $type
     * @return \QCC\CampusM\CloudService\StructType\FindFriendsRequest
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->type);
        } else {
            $this->type = $type;
        }
        return $this;
    }
    /**
     * Get latitude value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLatitude()
    {
        return isset($this->latitude) ? $this->latitude : null;
    }
    /**
     * Set latitude value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $latitude
     * @return \QCC\CampusM\CloudService\StructType\FindFriendsRequest
     */
    public function setLatitude($latitude = null)
    {
        if (is_null($latitude) || (is_array($latitude) && empty($latitude))) {
            unset($this->latitude);
        } else {
            $this->latitude = $latitude;
        }
        return $this;
    }
    /**
     * Get longitude value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLongitude()
    {
        return isset($this->longitude) ? $this->longitude : null;
    }
    /**
     * Set longitude value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $longitude
     * @return \QCC\CampusM\CloudService\StructType\FindFriendsRequest
     */
    public function setLongitude($longitude = null)
    {
        if (is_null($longitude) || (is_array($longitude) && empty($longitude))) {
            unset($this->longitude);
        } else {
            $this->longitude = $longitude;
        }
        return $this;
    }
    /**
     * Get group value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroup()
    {
        return isset($this->group) ? $this->group : null;
    }
    /**
     * Set group value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $group
     * @return \QCC\CampusM\CloudService\StructType\FindFriendsRequest
     */
    public function setGroup($group = null)
    {
        // validation for constraint: string
        if (!is_null($group) && !is_string($group)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($group)), __LINE__);
        }
        if (is_null($group) || (is_array($group) && empty($group))) {
            unset($this->group);
        } else {
            $this->group = $group;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\FindFriendsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
