<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for feeds StructType
 * @subpackage Structs
 */
class Feeds extends AbstractStructBase
{
    /**
     * The feed
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\Feed[]
     */
    public $feed;
    /**
     * Constructor method for feeds
     * @uses Feeds::setFeed()
     * @param \QCC\CampusM\CloudService\StructType\Feed[] $feed
     */
    public function __construct(array $feed = array())
    {
        $this
            ->setFeed($feed);
    }
    /**
     * Get feed value
     * @return \QCC\CampusM\CloudService\StructType\Feed[]|null
     */
    public function getFeed()
    {
        return $this->feed;
    }
    /**
     * Set feed value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\Feed[] $feed
     * @return \QCC\CampusM\CloudService\StructType\Feeds
     */
    public function setFeed(array $feed = array())
    {
        foreach ($feed as $feedsFeedItem) {
            // validation for constraint: itemType
            if (!$feedsFeedItem instanceof \QCC\CampusM\CloudService\StructType\Feed) {
                throw new \InvalidArgumentException(sprintf('The feed property can only contain items of \QCC\CampusM\CloudService\StructType\Feed, "%s" given', is_object($feedsFeedItem) ? get_class($feedsFeedItem) : gettype($feedsFeedItem)), __LINE__);
            }
        }
        $this->feed = $feed;
        return $this;
    }
    /**
     * Add item to feed value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\Feed $item
     * @return \QCC\CampusM\CloudService\StructType\Feeds
     */
    public function addToFeed(\QCC\CampusM\CloudService\StructType\Feed $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \QCC\CampusM\CloudService\StructType\Feed) {
            throw new \InvalidArgumentException(sprintf('The feed property can only contain items of \QCC\CampusM\CloudService\StructType\Feed, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->feed[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\Feeds
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
