<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for feedItems StructType
 * @subpackage Structs
 */
class FeedItems extends AbstractStructBase
{
    /**
     * The feedItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\FeedItem[]
     */
    public $feedItem;
    /**
     * Constructor method for feedItems
     * @uses FeedItems::setFeedItem()
     * @param \QCC\CampusM\CloudService\StructType\FeedItem[] $feedItem
     */
    public function __construct(array $feedItem = array())
    {
        $this
            ->setFeedItem($feedItem);
    }
    /**
     * Get feedItem value
     * @return \QCC\CampusM\CloudService\StructType\FeedItem[]|null
     */
    public function getFeedItem()
    {
        return $this->feedItem;
    }
    /**
     * Set feedItem value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\FeedItem[] $feedItem
     * @return \QCC\CampusM\CloudService\StructType\FeedItems
     */
    public function setFeedItem(array $feedItem = array())
    {
        foreach ($feedItem as $feedItemsFeedItemItem) {
            // validation for constraint: itemType
            if (!$feedItemsFeedItemItem instanceof \QCC\CampusM\CloudService\StructType\FeedItem) {
                throw new \InvalidArgumentException(sprintf('The feedItem property can only contain items of \QCC\CampusM\CloudService\StructType\FeedItem, "%s" given', is_object($feedItemsFeedItemItem) ? get_class($feedItemsFeedItemItem) : gettype($feedItemsFeedItemItem)), __LINE__);
            }
        }
        $this->feedItem = $feedItem;
        return $this;
    }
    /**
     * Add item to feedItem value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\FeedItem $item
     * @return \QCC\CampusM\CloudService\StructType\FeedItems
     */
    public function addToFeedItem(\QCC\CampusM\CloudService\StructType\FeedItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \QCC\CampusM\CloudService\StructType\FeedItem) {
            throw new \InvalidArgumentException(sprintf('The feedItem property can only contain items of \QCC\CampusM\CloudService\StructType\FeedItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->feedItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\FeedItems
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
