<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for feedItem StructType
 * @subpackage Structs
 */
class FeedItem extends AbstractStructBase
{
    /**
     * The reference
     * @var string
     */
    public $reference;
    /**
     * The source
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $source;
    /**
     * The result
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \QCC\CampusM\CloudService\StructType\ExpressionResult[]
     */
    public $result;
    /**
     * Constructor method for feedItem
     * @uses FeedItem::setReference()
     * @uses FeedItem::setSource()
     * @uses FeedItem::setResult()
     * @param string $reference
     * @param string $source
     * @param \QCC\CampusM\CloudService\StructType\ExpressionResult[] $result
     */
    public function __construct($reference = null, $source = null, array $result = array())
    {
        $this
            ->setReference($reference)
            ->setSource($source)
            ->setResult($result);
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \QCC\CampusM\CloudService\StructType\FeedItem
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @param string $source
     * @return \QCC\CampusM\CloudService\StructType\FeedItem
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($source)), __LINE__);
        }
        $this->source = $source;
        return $this;
    }
    /**
     * Get result value
     * @return \QCC\CampusM\CloudService\StructType\ExpressionResult[]|null
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * Set result value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\ExpressionResult[] $result
     * @return \QCC\CampusM\CloudService\StructType\FeedItem
     */
    public function setResult(array $result = array())
    {
        foreach ($result as $feedItemResultItem) {
            // validation for constraint: itemType
            if (!$feedItemResultItem instanceof \QCC\CampusM\CloudService\StructType\ExpressionResult) {
                throw new \InvalidArgumentException(sprintf('The result property can only contain items of \QCC\CampusM\CloudService\StructType\ExpressionResult, "%s" given', is_object($feedItemResultItem) ? get_class($feedItemResultItem) : gettype($feedItemResultItem)), __LINE__);
            }
        }
        $this->result = $result;
        return $this;
    }
    /**
     * Add item to result value
     * @throws \InvalidArgumentException
     * @param \QCC\CampusM\CloudService\StructType\ExpressionResult $item
     * @return \QCC\CampusM\CloudService\StructType\FeedItem
     */
    public function addToResult(\QCC\CampusM\CloudService\StructType\ExpressionResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \QCC\CampusM\CloudService\StructType\ExpressionResult) {
            throw new \InvalidArgumentException(sprintf('The result property can only contain items of \QCC\CampusM\CloudService\StructType\ExpressionResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->result[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\FeedItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
