<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for feed StructType
 * @subpackage Structs
 */
class Feed extends AbstractStructBase
{
    /**
     * The code
     * @var int
     */
    public $code;
    /**
     * The desc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $desc;
    /**
     * The order
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $order;
    /**
     * The url
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $url;
    /**
     * The img
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $img;
    /**
     * Constructor method for feed
     * @uses Feed::setCode()
     * @uses Feed::setDesc()
     * @uses Feed::setOrder()
     * @uses Feed::setUrl()
     * @uses Feed::setImg()
     * @param int $code
     * @param string $desc
     * @param int $order
     * @param string $url
     * @param string $img
     */
    public function __construct($code = null, $desc = null, $order = null, $url = null, $img = null)
    {
        $this
            ->setCode($code)
            ->setDesc($desc)
            ->setOrder($order)
            ->setUrl($url)
            ->setImg($img);
    }
    /**
     * Get code value
     * @return int|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param int $code
     * @return \QCC\CampusM\CloudService\StructType\Feed
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !is_numeric($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get desc value
     * @return string|null
     */
    public function getDesc()
    {
        return $this->desc;
    }
    /**
     * Set desc value
     * @param string $desc
     * @return \QCC\CampusM\CloudService\StructType\Feed
     */
    public function setDesc($desc = null)
    {
        // validation for constraint: string
        if (!is_null($desc) && !is_string($desc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($desc)), __LINE__);
        }
        $this->desc = $desc;
        return $this;
    }
    /**
     * Get order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * Set order value
     * @param int $order
     * @return \QCC\CampusM\CloudService\StructType\Feed
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !is_numeric($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($order)), __LINE__);
        }
        $this->order = $order;
        return $this;
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \QCC\CampusM\CloudService\StructType\Feed
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Get img value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImg()
    {
        return isset($this->img) ? $this->img : null;
    }
    /**
     * Set img value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $img
     * @return \QCC\CampusM\CloudService\StructType\Feed
     */
    public function setImg($img = null)
    {
        // validation for constraint: string
        if (!is_null($img) && !is_string($img)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($img)), __LINE__);
        }
        if (is_null($img) || (is_array($img) && empty($img))) {
            unset($this->img);
        } else {
            $this->img = $img;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\Feed
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
