<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for educauseExhibitors StructType
 * @subpackage Structs
 */
class EducauseExhibitors extends AbstractStructBase
{
    /**
     * The exhibitorId
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $exhibitorId;
    /**
     * Constructor method for educauseExhibitors
     * @uses EducauseExhibitors::setExhibitorId()
     * @param string[] $exhibitorId
     */
    public function __construct(array $exhibitorId = array())
    {
        $this
            ->setExhibitorId($exhibitorId);
    }
    /**
     * Get exhibitorId value
     * @return string[]|null
     */
    public function getExhibitorId()
    {
        return $this->exhibitorId;
    }
    /**
     * Set exhibitorId value
     * @throws \InvalidArgumentException
     * @param string[] $exhibitorId
     * @return \QCC\CampusM\CloudService\StructType\EducauseExhibitors
     */
    public function setExhibitorId(array $exhibitorId = array())
    {
        foreach ($exhibitorId as $educauseExhibitorsExhibitorIdItem) {
            // validation for constraint: itemType
            if (!is_string($educauseExhibitorsExhibitorIdItem)) {
                throw new \InvalidArgumentException(sprintf('The exhibitorId property can only contain items of string, "%s" given', is_object($educauseExhibitorsExhibitorIdItem) ? get_class($educauseExhibitorsExhibitorIdItem) : gettype($educauseExhibitorsExhibitorIdItem)), __LINE__);
            }
        }
        $this->exhibitorId = $exhibitorId;
        return $this;
    }
    /**
     * Add item to exhibitorId value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \QCC\CampusM\CloudService\StructType\EducauseExhibitors
     */
    public function addToExhibitorId($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The exhibitorId property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->exhibitorId[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\EducauseExhibitors
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
