<?php

namespace QCC\CampusM\CloudService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for directoryListRequest StructType
 * @subpackage Structs
 */
class DirectoryListRequest extends AbstractStructBase
{
    /**
     * The orgCode
     * @var int
     */
    public $orgCode;
    /**
     * The personId
     * @var int
     */
    public $personId;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The includeOptOuts
     * @var string
     */
    public $includeOptOuts;
    /**
     * The profileId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $profileId;
    /**
     * Constructor method for directoryListRequest
     * @uses DirectoryListRequest::setOrgCode()
     * @uses DirectoryListRequest::setPersonId()
     * @uses DirectoryListRequest::setPassword()
     * @uses DirectoryListRequest::setIncludeOptOuts()
     * @uses DirectoryListRequest::setProfileId()
     * @param int $orgCode
     * @param int $personId
     * @param string $password
     * @param string $includeOptOuts
     * @param int $profileId
     */
    public function __construct($orgCode = null, $personId = null, $password = null, $includeOptOuts = null, $profileId = null)
    {
        $this
            ->setOrgCode($orgCode)
            ->setPersonId($personId)
            ->setPassword($password)
            ->setIncludeOptOuts($includeOptOuts)
            ->setProfileId($profileId);
    }
    /**
     * Get orgCode value
     * @return int|null
     */
    public function getOrgCode()
    {
        return $this->orgCode;
    }
    /**
     * Set orgCode value
     * @param int $orgCode
     * @return \QCC\CampusM\CloudService\StructType\DirectoryListRequest
     */
    public function setOrgCode($orgCode = null)
    {
        // validation for constraint: int
        if (!is_null($orgCode) && !is_numeric($orgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgCode)), __LINE__);
        }
        $this->orgCode = $orgCode;
        return $this;
    }
    /**
     * Get personId value
     * @return int|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param int $personId
     * @return \QCC\CampusM\CloudService\StructType\DirectoryListRequest
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: int
        if (!is_null($personId) && !is_numeric($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \QCC\CampusM\CloudService\StructType\DirectoryListRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get includeOptOuts value
     * @return string|null
     */
    public function getIncludeOptOuts()
    {
        return $this->includeOptOuts;
    }
    /**
     * Set includeOptOuts value
     * @param string $includeOptOuts
     * @return \QCC\CampusM\CloudService\StructType\DirectoryListRequest
     */
    public function setIncludeOptOuts($includeOptOuts = null)
    {
        // validation for constraint: string
        if (!is_null($includeOptOuts) && !is_string($includeOptOuts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($includeOptOuts)), __LINE__);
        }
        $this->includeOptOuts = $includeOptOuts;
        return $this;
    }
    /**
     * Get profileId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProfileId()
    {
        return isset($this->profileId) ? $this->profileId : null;
    }
    /**
     * Set profileId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $profileId
     * @return \QCC\CampusM\CloudService\StructType\DirectoryListRequest
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !is_numeric($profileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($profileId)), __LINE__);
        }
        if (is_null($profileId) || (is_array($profileId) && empty($profileId))) {
            unset($this->profileId);
        } else {
            $this->profileId = $profileId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \QCC\CampusM\CloudService\StructType\DirectoryListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
